﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;

namespace Mall.Repository.User
{
    /// <summary>
    /// 用户余额仓储层
    /// </summary>
    public class RB_Member_BalanceRepository : BaseRepository<RB_Member_Balance>
    {
        public string MemberTableName { get { return nameof(RB_Member_User); } }
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Member_Balance); } }
        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Member_Balance_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Member_Balance_Extend dmodel)
        {
            string where = " 1=1 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Member_Balance.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Member_Balance.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and {nameof(RB_Member_Balance.Id)}={dmodel.Id}";
            }
            if (dmodel.Type > 0)
            {
                where += $@" and {nameof(RB_Member_Balance.Type)}={dmodel.Type}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and {nameof(RB_Member_Balance.UserId)}={dmodel.UserId}";
            }
            if (dmodel.CreateDate.HasValue)
            {
                where += $@" and date_format( {nameof(RB_Member_Balance.CreateDate)}, '%Y-%m' )  =date_format( '{dmodel.CreateDate.Value}', '%Y-%m' ) ";
            }
            string sql = $@"select * from RB_Member_Balance where {where} order by Id desc";
            return GetPage<RB_Member_Balance_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Member_Balance_Extend> GetList(RB_Member_Balance_Extend dmodel)
        {
            string where = " 1=1 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Member_Balance.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Member_Balance.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and {nameof(RB_Member_Balance.Id)}={dmodel.Id}";
            }
            if (dmodel.Type > 0)
            {
                where += $@" and {nameof(RB_Member_Balance.Type)}={dmodel.Type}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and {nameof(RB_Member_Balance.UserId)}={dmodel.UserId}";
            }

            string sql = $@"select * from RB_Member_Balance where {where} order by Id desc";
            return Get<RB_Member_Balance_Extend>(sql).ToList();
        }


        /// <summary>
        /// 营销中心-余额收支
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Member_Balance_Extend> GetMemberBalancePageList(int pageIndex, int pageSize, out long rowCount, RB_Member_Balance_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT a.*,b.`Name` as MemberName FROM {TableName} as a LEFT JOIN {MemberTableName} as b on a.UserId = b.Id WHERE 1=1 ");
            if (query != null)
            {
                if (query.Id > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Member_Balance_Extend.Id)}={query.Id}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Member_Balance_Extend.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Member_Balance_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.PlatformType > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Member_Balance_Extend.PlatformType)}={(int)query.PlatformType}");
                }
                if (!string.IsNullOrWhiteSpace(query.MemberName))
                {
                    builder.Append($" AND b.{nameof(RB_Member_Balance_Extend.MemberName)} like '%{query.MemberName}%'");
                }
                if (!string.IsNullOrWhiteSpace(query.StartDate))
                {
                    builder.Append($" AND DATE_FORMAT(a.{nameof(RB_Member_Balance_Extend.CreateDate)},'%Y-%m-%d' )>= DATE_FORMAT('{query.StartDate}','%Y-%m-%d' )");
                }
                if (!string.IsNullOrWhiteSpace(query.EndDate))
                {
                    builder.Append($" AND DATE_FORMAT(a.{nameof(RB_Member_Balance_Extend.CreateDate)},'%Y-%m-%d' )<= DATE_FORMAT('{query.EndDate}','%Y-%m-%d' )");
                }
            }
            return GetPage<RB_Member_Balance_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }

        /// <summary>
        /// 导出余额收支
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Member_Balance_Extend> GetMemberBalanceExport(RB_Member_Balance_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT a.*,b.`Name` as MemberName,b.Moblie FROM {TableName} as a LEFT JOIN {MemberTableName} as b on a.UserId = b.Id WHERE 1=1 ");
            if (query != null)
            {
                if (query.Id > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Member_Balance_Extend.Id)}={query.Id}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Member_Balance_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Member_Balance_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (!string.IsNullOrWhiteSpace(query.MemberName))
                {
                    builder.Append($" AND b.{nameof(RB_Member_Balance_Extend.MemberName)} like '%{query.MemberName}%'");
                }
                if (!string.IsNullOrWhiteSpace(query.StartDate))
                {
                    builder.Append($" AND DATE_FORMAT(a.{nameof(RB_Member_Balance_Extend.CreateDate)},'%Y-%m-%d' )>= DATE_FORMAT('{nameof(RB_Member_Balance_Extend.StartDate)}','%Y-%m-%d' )");
                }
                if (!string.IsNullOrWhiteSpace(query.EndDate))
                {
                    builder.Append($" AND DATE_FORMAT(a.{nameof(RB_Member_Balance_Extend.CreateDate)},'%Y-%m-%d' )<= DATE_FORMAT('{nameof(RB_Member_Balance_Extend.EndDate)}','%Y-%m-%d' )");
                }
            }
            return Get<RB_Member_Balance_Extend>(builder.ToString()).ToList();
        }






    }
}
