﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using System.Web;
using Google.Protobuf.WellKnownTypes;
using Mall.Common.API;
using Mall.Common.Pay.WeChatPat;
using Mall.Common.Plugin;
using Mall.Module.User;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json.Linq;

namespace Mall.WebApi.Controllers.AppletWeChat
{


    [Route("api/[controller]/[action]/{MallBaseId?}/{TenantId?}")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class WeChatNotifyController : Controller
    {
        private static object _lock = new object();

        UserCommonModule userCommonModule = new UserCommonModule();

        //public UserModule userModule = new UserModule();
        Module.MarketingCenter.RechargeModule rechargeModule = new Module.MarketingCenter.RechargeModule();
        private IHttpContextAccessor _accessor;

        /// <summary>
        /// 构造函数
        /// </summary>
        /// <param name="accessor"></param>
        public WeChatNotifyController(IHttpContextAccessor accessor)
        {
            _accessor = accessor;
        }
        /// <summary>
        /// 订单支付回调
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        public string Notify()
        {
            var req = new RequestHandler();
            App_Code.PayUtil PayUtil = new App_Code.PayUtil();
            var result = PayUtil.Notify(_accessor);
            if (result.IsSuccess)
            {
                var dic = ((Dictionary<string, string>)result.Data);
                //开始回写订单状态
                lock (_lock)
                {
                    string sOrderNo = dic["sOrderNo"];//订单号 时间挫+OrderId
                    int OrderId = Convert.ToInt32(sOrderNo[17..]);

                    decimal dPaid = Convert.ToDecimal(dic["dPrice"]) / 100;
                    string sPayerOpenID = dic["sPayerOpenID"];

                    int UserId = Convert.ToInt32(dic["bIsRecharge"]);
                    string TransactionId = dic["sTradeNo"];
                    string PayType = dic["OrderPayType"];
                    DateTime PayDate = DateTime.ParseExact(dic["PayDate"], "yyyyMMddHHmmss", System.Globalization.CultureInfo.CurrentCulture);//转换时间// Convert.ToDateTime(dic["PayDate"]);

                    #region 新增订单支付信息

                    userCommonModule.InsertOrderPayInfo(UserId, OrderId, sOrderNo, TransactionId, Common.Enum.Goods.OrderPayTypeEnum.WeChatPay, PayType, dPaid, PayDate, 0);


                    #endregion
                }
                //告诉微信我们已经处理成功，不需要再调用我们的接口了
                req.SetParameter("return_code", "SUCCESS");
                req.SetParameter("return_msg", "OK");
                var reqXml = req.ParseXml();
                return reqXml;
                //  return ApiResult.Success("", reqXml);
            }
            else
            {
                req.SetParameter("return_code", "FAIL");
                req.SetParameter("return_msg", "订单失败");
                var reqXmlFAIL = req.ParseXml();
                LogHelper.Write(null, "Notify返回信息：" + reqXmlFAIL);
                return reqXmlFAIL;
                // return ApiResult.Failed("", reqXmlFAIL);
            }
        }


        /// <summary>
        /// 订单支付回调
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        public string AllNotify(int MallBaseId, int TenantId)
        {
            var req = new RequestHandler();
            App_Code.PayUtil PayUtil = new App_Code.PayUtil();
            var result = PayUtil.AllNotify(_accessor, MallBaseId, TenantId);
            if (result.IsSuccess)
            {
                var dic = ((Dictionary<string, string>)result.Data);
                //开始回写订单状态
                lock (_lock)
                {
                    string sOrderNo = dic["sOrderNo"];//订单号 时间挫+OrderId
                    int OrderId = Convert.ToInt32(sOrderNo[17..]);

                    decimal dPaid = Convert.ToDecimal(dic["dPrice"]) / 100;
                    string sPayerOpenID = dic["sPayerOpenID"];

                    int UserId = Convert.ToInt32(dic["bIsRecharge"]);
                    string TransactionId = dic["sTradeNo"];
                    string PayType = dic["OrderPayType"];
                    DateTime PayDate = DateTime.ParseExact(dic["PayDate"], "yyyyMMddHHmmss", System.Globalization.CultureInfo.CurrentCulture);//转换时间// Convert.ToDateTime(dic["PayDate"]);

                    #region 新增订单支付信息

                    userCommonModule.InsertOrderPayInfo(UserId, OrderId, sOrderNo, TransactionId, Common.Enum.Goods.OrderPayTypeEnum.WeChatPay, PayType, dPaid, PayDate, 0);


                    #endregion
                }
                //告诉微信我们已经处理成功，不需要再调用我们的接口了
                req.SetParameter("return_code", "SUCCESS");
                req.SetParameter("return_msg", "OK");
                var reqXml = req.ParseXml();
                return reqXml;
                //  return ApiResult.Success("", reqXml);
            }
            else
            {
                req.SetParameter("return_code", "FAIL");
                req.SetParameter("return_msg", "订单失败");
                var reqXmlFAIL = req.ParseXml();
                LogHelper.Write(null, "Notify返回信息：" + reqXmlFAIL);
                return reqXmlFAIL;
                // return ApiResult.Failed("", reqXmlFAIL);
            }
        }


        /// <summary>
        /// 订单支付回调
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        public string NotifyZhouTian()
        {
            var req = new RequestHandler();
            App_Code.PayUtil PayUtil = new App_Code.PayUtil();
            var result = PayUtil.NotifyZhouTian(_accessor);
            LogHelper.WriteInfo( "NotifyZhouTian返回信息进来了" );
            if (result.IsSuccess)
            {
                LogHelper.WriteInfo( "NotifyZhouTian回调成功："+ result.ToString());
                var dic = ((Dictionary<string, string>)result.Data);
                //开始回写订单状态
                lock (_lock)
                {
                    string sOrderNo = dic["sOrderNo"];//订单号 时间挫+OrderId
                    int OrderId = Convert.ToInt32(sOrderNo[17..]);

                    decimal dPaid = Convert.ToDecimal(dic["dPrice"]) / 100;
                    string sPayerOpenID = dic["sPayerOpenID"];
                    int UserId = Convert.ToInt32(dic["bIsRecharge"]);
                    string TransactionId = dic["sTradeNo"];
                    string PayType = dic["OrderPayType"];
                    DateTime PayDate = DateTime.ParseExact(dic["PayDate"], "yyyyMMddHHmmss", System.Globalization.CultureInfo.CurrentCulture);//转换时间// Convert.ToDateTime(dic["PayDate"]);

                    #region 新增订单支付信息
                    LogHelper.WriteInfo( "NotifyZhouTian订单信息");
                    userCommonModule.InsertOrderPayInfo(UserId, OrderId, sOrderNo, TransactionId, Common.Enum.Goods.OrderPayTypeEnum.WeChatPay, PayType, dPaid, PayDate, 0);


                    #endregion
                }
                //告诉微信我们已经处理成功，不需要再调用我们的接口了
                req.SetParameter("return_code", "SUCCESS");
                req.SetParameter("return_msg", "OK");
                var reqXml = req.ParseXml();
                return reqXml;
                //  return ApiResult.Success("", reqXml);
            }
            else
            {
                req.SetParameter("return_code", "FAIL");
                req.SetParameter("return_msg", "订单失败");
                var reqXmlFAIL = req.ParseXml();
                LogHelper.Write(null, "Notify返回信息：" + reqXmlFAIL);
                return reqXmlFAIL;
                // return ApiResult.Failed("", reqXmlFAIL);
            }
        }



        /// <summary>
        /// 会员充值支付回调
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        public string RechargeNotify()
        {
            var req = new RequestHandler();
            App_Code.PayUtil PayUtil = new App_Code.PayUtil();
            var result = PayUtil.Notify(_accessor);
            if (result.IsSuccess)
            {
                var dic = ((Dictionary<string, string>)result.Data);
                //开始回写订单状态
                lock (_lock)
                {
                    string sOrderNo = dic["sOrderNo"];//订单号 时间挫+OrderId
                    int OrderId = Convert.ToInt32(sOrderNo[17..]);

                    decimal dPaid = Convert.ToDecimal(dic["dPrice"]) / 100;
                    string sPayerOpenID = dic["sPayerOpenID"];
                    int UserId = Convert.ToInt32(dic["bIsRecharge"]);
                    string TransactionId = dic["sTradeNo"];
                    string PayType = dic["OrderPayType"];
                    DateTime PayDate = DateTime.ParseExact(dic["PayDate"], "yyyyMMddHHmmss", System.Globalization.CultureInfo.CurrentCulture);//转换时间

                    #region 新增订单支付信息

                    rechargeModule.UpdateBalanceRecharge(UserId, OrderId, sOrderNo, TransactionId, Common.Enum.Goods.OrderPayTypeEnum.WeChatPay, PayType, dPaid, PayDate);


                    #endregion
                }
                //告诉微信我们已经处理成功，不需要再调用我们的接口了
                req.SetParameter("return_code", "SUCCESS");
                req.SetParameter("return_msg", "OK");
                var reqXml = req.ParseXml();
                return reqXml;
                //  return ApiResult.Success("", reqXml);
            }
            else
            {
                req.SetParameter("return_code", "FAIL");
                req.SetParameter("return_msg", "订单失败");
                var reqXmlFAIL = req.ParseXml();
                LogHelper.Write(null, "Notify返回信息：" + reqXmlFAIL);
                return reqXmlFAIL;
                // return ApiResult.Failed("", reqXmlFAIL);
            }
        }



        /// <summary>
        /// 会员购买支付回调
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        public string VipBuyNotify()
        {
            LogHelper.Write(null, "VipBuyNotify返回信息进来了");
            var req = new RequestHandler();
            App_Code.PayUtil PayUtil = new App_Code.PayUtil();
            var result = PayUtil.Notify(_accessor);
            if (result.IsSuccess)
            {
                var dic = ((Dictionary<string, string>)result.Data);
                //开始回写订单状态
                lock (_lock)
                {
                    string sOrderNo = dic["sOrderNo"];//订单号 时间挫+OrderId
                    int OrderId = Convert.ToInt32(sOrderNo[17..]);

                    decimal dPaid = Convert.ToDecimal(dic["dPrice"]) / 100;
                    string sPayerOpenID = dic["sPayerOpenID"];
                    int UserId = Convert.ToInt32(dic["bIsRecharge"]);
                    string TransactionId = dic["sTradeNo"];
                    string PayType = dic["OrderPayType"];
                    DateTime PayDate = DateTime.ParseExact(dic["PayDate"], "yyyyMMddHHmmss", System.Globalization.CultureInfo.CurrentCulture);//转换时间

                    #region 修改会员购买支付信息

                    userCommonModule.InsertVipBuyCommission(UserId, OrderId, sOrderNo, TransactionId, Common.Enum.Goods.OrderPayTypeEnum.WeChatPay, dPaid, PayDate);
                    #endregion
                }
                //告诉微信我们已经处理成功，不需要再调用我们的接口了
                req.SetParameter("return_code", "SUCCESS");
                req.SetParameter("return_msg", "OK");
                var reqXml = req.ParseXml();
                return reqXml;
                //  return ApiResult.Success("", reqXml);
            }
            else
            {
                req.SetParameter("return_code", "FAIL");
                req.SetParameter("return_msg", "订单失败");
                var reqXmlFAIL = req.ParseXml();
                LogHelper.Write(null, "Notify返回信息：" + reqXmlFAIL);
                return reqXmlFAIL;
                // return ApiResult.Failed("", reqXmlFAIL);
            }
        }



        ///// <summary>
        ///// 会员购买支付回调
        ///// </summary>
        ///// <returns></returns>
        //[HttpGet]
        //[HttpPost]
        //public string MemberBuyNotify()
        //{
        //    var req = new RequestHandler();
        //    App_Code.PayUtil PayUtil = new App_Code.PayUtil();
        //    var result = PayUtil.Notify(_accessor);
        //    if (result.IsSuccess)
        //    {
        //        var dic = ((Dictionary<string, string>)result.Data);
        //        //开始回写订单状态
        //        lock (_lock)
        //        {
        //            string sOrderNo = dic["sOrderNo"];//订单号 时间挫+OrderId
        //            int OrderId = Convert.ToInt32(sOrderNo[17..]);

        //            decimal dPaid = Convert.ToDecimal(dic["dPrice"]) / 100;
        //            string sPayerOpenID = dic["sPayerOpenID"];
        //            int UserId = Convert.ToInt32(dic["bIsRecharge"]);
        //            string TransactionId = dic["sTradeNo"];
        //            string PayType = dic["OrderPayType"];
        //            DateTime PayDate = DateTime.ParseExact(dic["PayDate"], "yyyyMMddHHmmss", System.Globalization.CultureInfo.CurrentCulture);//转换时间

        //            #region 修改会员购买支付信息

        //            userModule.UpdateMemberBuy(UserId, OrderId, sOrderNo, TransactionId, Common.Enum.Goods.OrderPayTypeEnum.WeChatPay, dPaid, PayDate);
        //            #endregion
        //        }
        //        //告诉微信我们已经处理成功，不需要再调用我们的接口了
        //        req.SetParameter("return_code", "SUCCESS");
        //        req.SetParameter("return_msg", "OK");
        //        var reqXml = req.ParseXml();
        //        return reqXml;
        //        //  return ApiResult.Success("", reqXml);
        //    }
        //    else
        //    {
        //        req.SetParameter("return_code", "FAIL");
        //        req.SetParameter("return_msg", "订单失败");
        //        var reqXmlFAIL = req.ParseXml();
        //        LogHelper.Write(null, "Notify返回信息：" + reqXmlFAIL);
        //        return reqXmlFAIL;
        //        // return ApiResult.Failed("", reqXmlFAIL);
        //    }
        //}
    }
}