﻿using System;
using Mall.Common.AOP;
using Mall.Common.Enum;
namespace Mall.Model.Entity.Finance
{

    /// <summary>
    /// rb_workflow_template Entity
    /// </summary> 
    [Serializable]
    [DB(ConnectionName = "FinanceConnection")]
    public class Rb_Workflow_Template
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 流程名称
        /// </summary>        
        public string Name
        {
            get;
            set;
        }
        /// <summary>
        /// 1正常  2 停用    3删除-->add by:2018-08-23 财务自定义 
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }
        /// <summary>
        /// 分组类型 1出勤休假
        /// </summary>        
        public int? GroupType
        {
            get;
            set;
        }
        /// <summary>
        /// 所属集团
        /// </summary>        
        public int? RB_GroupId
        {
            get;
            set;
        }
        /// <summary>
        /// 所属公司
        /// </summary>        
        public int? RB_BranchId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateBy
        /// </summary>        
        public int? CreateBy
        {
            get;
            set;
        }
        /// <summary>
        /// CreateTime
        /// </summary>        
        public DateTime? CreateTime
        {
            get;
            set;
        }
        /// <summary>
        /// UpdateBy
        /// </summary>        
        public int? UpdateBy
        {
            get;
            set;
        }
        /// <summary>
        /// UpdateTime
        /// </summary>        
        public DateTime? UpdateTime
        {
            get;
            set;
        }
        /// <summary>
        /// 1请假  2出差  3  外出  4  补卡 5-收款流程  6- 付款流程 7-发票流程
        /// </summary>        
        public int? TemplateType
        {
            get;
            set;
        }
        /// <summary>
        /// 1 不启用自动去重  2同一个审批人在流程中出现多次时，仅保留第一个 3同一个审批人在流程中出现多次时，仅保留最后一个  4同一个审批人仅在连续出现时，自动去重
        /// </summary>        
        public int? AuditDistinct
        {
            get;
            set;
        }
        /// <summary>
        /// 1 仅全部同意后通知 2仅发起时通知  3发起时和全部同意后均通知
        /// </summary>        
        public int? NotificationCP
        {
            get;
            set;
        }

        /// <summary>
        /// 类型 1-OA，2-财务
        /// </summary>
        public int? Type { get; set; }

        /// <summary>
        /// 描述
        /// </summary>
        public string DescribeInfo { get; set; }
        /// <summary>
        /// 1-收入2-支出
        /// </summary>
        public Common.Enum.Finance.WFTempLateClassEnum? TempLateClass { get; set; }
        /// <summary>
        /// 是否上传凭证0-不启用1-启用
        /// </summary>
        public int IsUploadPic
        {
            get;set;
        }
        /// <summary>
        /// 是否无条件显示   1是  2否
        /// </summary>
        public int? IsShow { get => isShow; set => isShow = value; }

        private int? isShow = 1;

        /// <summary>
        /// 不显示时  可以查看的员工  逗号分隔
        /// </summary>
        public string ShowEmployee { get; set; }
        /// <summary>
        /// 不显示时  可以查看的部门  逗号分隔
        /// </summary>
        public string ShowDepartment { get; set; }
        /// <summary>
        /// 排序
        /// </summary>
        public int? Sort { get; set; }
        /// <summary>
        /// 来源  1财务   2资产管理
        /// </summary>
        public int? TemplateSorce { get; set; }
        /// <summary>
        /// 资产管理  审批类型  1领取流程  2 退库流程 ~~
        /// </summary>
        public int? PropertyType { get; set; }
    }
}