﻿using VT.FW.DB;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.Property
{

    /// <summary>
    /// 商品重新入库记录实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "PropertyConnection")]
    public class RB_Warehouseout_Inventory
    {
        /// <summary>
        /// Id
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 订单id
        /// </summary>
        public int OrderId { get; set; }

        /// <summary>
        /// 订单明细id
        /// </summary>
        public int OrderGoodsId { get; set; }

        /// <summary>
        /// 订单号
        /// </summary>
        public string OrderNo { get; set; }

        /// <summary>
        /// 出库id
        /// </summary>
        public int StockOutId { get; set; }

        /// <summary>
        /// 物料id
        /// </summary>
        public int MaterialId { get; set; }

        /// <summary>
        /// 重新入库数量
        /// </summary>
        public int InventoryNum { get; set; }

        /// <summary>
        /// 状态 0 正常 1删除
        /// </summary>
        public int Status { get; set; }

        /// <summary>
        /// 公司
        /// </summary>
        public int RB_Branch_Id { get; set; }

        /// <summary>
        /// 集团
        /// </summary>
        public int RB_Group_Id { get; set; }

        /// <summary>
        /// CreateBy
        /// </summary>
        public int CreateBy { get; set; }

        /// <summary>
        /// CreateDate
        /// </summary>
        public DateTime CreateDate { get; set; }

        /// <summary>
        /// 商户号
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }

        /// <summary>
        /// 财务单据id
        /// </summary>
        public int FinanceId { get; set; }

        /// <summary>
        /// 仓库id
        /// </summary>
        public int WarehouseId { get; set; }

        /// <summary>
        /// 生成入库单id
        /// </summary>
        public int StockInId { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        public string Remark { get; set; }

        /// <summary>
        /// 有效期ids
        /// </summary>
        public string ValidityIds { get; set; }
    }
}
