﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;

namespace Mall.Repository.User
{
    /// <summary>
    /// 商户用户仓储层
    /// </summary>
    public class RB_Member_UserRepository : RepositoryBase<RB_Member_User>
    {

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Member_User_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Member_User_Extend dmodel)
        {
            string where = " 1=1 ";
            if (dmodel.TenantId > 0) {
                where += $@" and {nameof(RB_Member_User.TenantId)}={dmodel.TenantId}";
            }
            if (!string.IsNullOrEmpty(dmodel.Name)) {
                where += $@" and {nameof(RB_Member_User.Name)} like '%{dmodel.Name}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.AliasName)) {
                where += $@" and {nameof(RB_Member_User.AliasName)} like '%{dmodel.AliasName}%'";
            }
            if (dmodel.Source > 0) {
                where += $@" and {nameof(RB_Member_User.Source)} ={(int)dmodel.Source}";
            }
            if (!string.IsNullOrEmpty(dmodel.Moblie)) {
                where += $@" and {nameof(RB_Member_User.Moblie)} like '%{dmodel.Moblie}%'";
            }
            if (dmodel.MemberGrade > 0) {
                where += $@" and {nameof(RB_Member_User.MemberGrade)}={dmodel.MemberGrade}";
            }
            if (dmodel.SuperiorId > 0) {
                where += $@" and {nameof(RB_Member_User.SuperiorId)}={dmodel.SuperiorId}";
            }
            string sql = $@"
select * from RB_Member_User where {where} order by CreateDate desc
";
            return GetPage<RB_Member_User_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Member_User_Extend> GetList(RB_Member_User_Extend dmodel)
        {
            string where = " 1=1 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Member_User.TenantId)}={dmodel.TenantId}";
            }
            if (!string.IsNullOrEmpty(dmodel.Name))
            {
                where += $@" and {nameof(RB_Member_User.Name)} like '%{dmodel.Name}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.AliasName))
            {
                where += $@" and {nameof(RB_Member_User.AliasName)} like '%{dmodel.AliasName}%'";
            }
            if (dmodel.Source > 0)
            {
                where += $@" and {nameof(RB_Member_User.Source)} ={(int)dmodel.Source}";
            }
            if (!string.IsNullOrEmpty(dmodel.Moblie))
            {
                where += $@" and {nameof(RB_Member_User.Moblie)} like '%{dmodel.Moblie}%'";
            }
            if (dmodel.MemberGrade > 0)
            {
                where += $@" and {nameof(RB_Member_User.MemberGrade)}={dmodel.MemberGrade}";
            }
            if (dmodel.SuperiorId > 0)
            {
                where += $@" and {nameof(RB_Member_User.SuperiorId)}={dmodel.SuperiorId}";
            }
            string sql = $@"
select * from RB_Member_User where {where} order by CreateDate desc
";
            return Get<RB_Member_User_Extend>(sql).ToList();
        }
    }
}
