﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Common;
using Mall.Common.Plugin;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using Mall.Repository;
using Mall.Repository.User;
using Mall.Repository.Product;
using Mall.Model.Extend.Product;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.Configuration.Json;
using Newtonsoft.Json;
using Mall.Repository.BaseSetUp;
using Mall.Common.Enum.User;
using Mall.Common.API;
using Newtonsoft.Json.Linq;
using System.Threading;
using Mall.Repository.Finance;
using NPOI.SS.Formula.Functions;
using VT.FW.DB;

namespace Mall.Module.User
{
    /// <summary>
    /// 微店处理层
    /// </summary>
    public class SmallShopsModule
    {
        /// <summary>
        /// 用户管理
        /// </summary>
        private readonly RB_Member_UserRepository member_UserRepository = new RB_Member_UserRepository();
        /// <summary>
        /// 小程序
        /// </summary>
        private readonly RB_MiniProgramRepository miniProgramRepository = new RB_MiniProgramRepository();
        /// <summary>
        /// 微店
        /// </summary>
        private readonly RB_SmallShops_InfoRepository smallShops_InfoRepository = new RB_SmallShops_InfoRepository();
        /// <summary>
        /// 微店价格
        /// </summary>
        private readonly RB_SmallShops_PriceRepository smallShops_PriceRepository = new RB_SmallShops_PriceRepository();
        /// <summary>
        /// 微店基础
        /// </summary>
        private readonly RB_MicroShop_BasicsRepository microShop_BasicsRepository = new RB_MicroShop_BasicsRepository();
        /// <summary>
        /// 商品表
        /// </summary>
        private readonly RB_GoodsRepository goodsRepository = new RB_GoodsRepository();
        /// <summary>
        /// 规格价格
        /// </summary>
        private readonly RB_Goods_SpecificationPriceRepository goods_SpecificationPriceRepository = new RB_Goods_SpecificationPriceRepository();
        /// <summary>
        /// 规格
        /// </summary>
        private readonly RB_Goods_SpecificationRepository goods_SpecificationRepository = new RB_Goods_SpecificationRepository();
        /// <summary>
        /// 规格值
        /// </summary>
        private readonly RB_Goods_SpecificationValueRepository goods_SpecificationValueRepository = new RB_Goods_SpecificationValueRepository();

        /// <summary>
        /// 规格值
        /// </summary>
        private readonly RB_SmallShops_CustomRepository smallShopsCustomRepository = new RB_SmallShops_CustomRepository();

        /// <summary>
        /// 订单明细
        /// </summary>
        private readonly RB_Goods_OrderDetailRepository goods_OrderDetailRepository = new RB_Goods_OrderDetailRepository();
        private readonly RB_SmallShops_CommissionRepository smallShopsCommissionRepository = new RB_SmallShops_CommissionRepository();
        private readonly RB_SmallShops_RemitRepository  smallShopsRemitRepository = new RB_SmallShops_RemitRepository();


        
        #region 微店管理

        /// <summary>
        /// 获取微店分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_SmallShops_Info_Extend> GetSmallShopsPageList(int pageIndex, int pageSize, out long count, RB_SmallShops_Info_Extend demodel)
        {
            var list = smallShops_InfoRepository.GetPageList(pageIndex, pageSize, out count, demodel);
            return list;
        }
        /// <summary>
        /// 获取下拉
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_SmallShops_Info_Extend> GetSmallShopsDropDownList(int pageIndex, int pageSize, out long count, RB_SmallShops_Info_Extend demodel)
        {
            return smallShops_InfoRepository.GetSmallShopsDropDownList(pageIndex, pageSize, out count, demodel);
        }

        /// <summary>
        /// 获取微店信息
        /// </summary>
        /// <param name="smallShopsId"></param>
        /// <returns></returns>
        public RB_SmallShops_Info_Extend GetSmallShopsInfo(int smallShopsId)
        {
            var model = smallShops_InfoRepository.GetEntity<RB_SmallShops_Info_Extend>(smallShopsId);
            model.NickName = member_UserRepository.GetEntity(model?.UserId ?? 0)?.Name ?? "";
            return model;
        }
        /// <summary>
        /// 根据用户id  获取微店信息
        /// </summary>
        /// <param name="UserId"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public RB_SmallShops_Info_Extend GetSmallShopsInfo_V2(int UserId, int tenantId, int mallBaseId)
        {
            var model = smallShops_InfoRepository.GetListForSingle(new RB_SmallShops_Info_Extend() { UserId = UserId, TenantId = tenantId, MallBaseId = mallBaseId }).FirstOrDefault();
            return model;
        }

        /// <summary>
        /// 微店审核
        /// </summary>
        /// <param name="ssmodel"></param>
        /// <param name="type"></param>
        /// <returns></returns>
        public bool SetSmallShopsAudit(RB_SmallShops_Info_Extend ssmodel, int type)
        {
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_SmallShops_Info.UpdateDate),DateTime.Now}
            };
            if (type == 1)
            {
                keyValues.Add(nameof(RB_SmallShops_Info.AuditStatus), DistributorAuditStatusEnum.Audited);
                keyValues.Add(nameof(RB_SmallShops_Info.AuditDate), DateTime.Now);
            }
            else if (type == 2)
            {
                keyValues.Add(nameof(RB_SmallShops_Info.AuditStatus), DistributorAuditStatusEnum.Reject);
            }
            else if (type == 3)
            {
                keyValues.Add(nameof(RB_SmallShops_Info.Remark), ssmodel.Remark);
            }
            else
            {
                return false;
            }

            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                     FiledName=nameof(RB_SmallShops_Info.Id),
                      FiledValue=ssmodel.Id,
                       OperatorEnum=OperatorEnum.Equal
                }
            };

            return smallShops_InfoRepository.Update(keyValues, wheres);
        }

        /// <summary>
        /// 修改店铺佣金
        /// </summary>
        /// <param name="smallShopsId"></param>
        /// <param name="commission"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool SetSmallShopsCommission(int smallShopsId, decimal commission, int tenantId, int mallBaseId, int empId)
        {
            var model = smallShops_InfoRepository.GetEntity(smallShopsId);
            if (model == null) { return false; }
            if (model.AuditStatus != DistributorAuditStatusEnum.Audited) { return false; }
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_SmallShops_Info.UpdateDate),DateTime.Now},
                { nameof(RB_SmallShops_Info.Commission),commission},
                { nameof(RB_SmallShops_Info.Remark),model.Remark +" EmpId:"+empId+"修改佣金：由"+(model.Commission??0)+"=>"+commission},
            };

            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                     FiledName=nameof(RB_SmallShops_Info.Id),
                      FiledValue=smallShopsId,
                       OperatorEnum=OperatorEnum.Equal
                }
            };

            return smallShops_InfoRepository.Update(keyValues, wheres);
        }

        /// <summary>
        /// 微店基础表
        /// </summary>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public Model.Entity.BaseSetUp.RB_MicroShop_Basics GetSmallShopsBaseInfo(int tenantId, int mallBaseId)
        {
            return microShop_BasicsRepository.GetMicroShopBasicsList(new Model.Entity.BaseSetUp.RB_MicroShop_Basics() { TenantId = tenantId, MallBaseId = mallBaseId }).FirstOrDefault();
        }

        #endregion


        #region 微店小程序

        /// <summary>
        /// 设置全局价格
        /// </summary>
        /// <param name="upPrice"></param>
        /// <param name="priceType"></param>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetSmallShopsGlobalPrice(decimal upPrice, int priceType, RB_SmallShops_Info_Extend model)
        {
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_SmallShops_Info_Extend.UpPrice),upPrice},
                { nameof(RB_SmallShops_Info_Extend.PriceType),priceType},
                { nameof(RB_SmallShops_Info_Extend.UpdateDate),DateTime.Now},
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                     FiledName=nameof(RB_SmallShops_Info_Extend.Id),
                      FiledValue=model.Id,
                       OperatorEnum=OperatorEnum.Equal
                }
            };
            return smallShops_InfoRepository.Update(keyValues, wheres);
        }

        /// <summary>
        /// 获取微店商品价格设置列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public object GetSmallShopsGoodsPricePageList(int pageIndex, int pageSize, out long count, RB_SmallShops_Price_Extend demodel)
        {
            var goodsList = smallShops_PriceRepository.GetSmallShopsGoodsPricePageList(pageIndex, pageSize, out count, demodel);
            List<object> RList = new List<object>();
            if (goodsList.Any())
            {
                //查询出所有商品id
                string goodsIds = string.Join(",", goodsList.Select(x => x.GoodsId ?? 0).Distinct());

                var glist = goodsRepository.GetSingleList(new RB_Goods_Extend() { GoodsIds = goodsIds, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                foreach (var item in glist)
                {
                    item.CoverImage = "";
                    if (!string.IsNullOrEmpty(item.CarouselImage) && item.CarouselImage != "[]")
                    {
                        List<string> CarouselIdList = JsonConvert.DeserializeObject<List<string>>(item.CarouselImage);
                        //封面图
                        item.CoverImage = CarouselIdList[0];
                    }
                }
                var splist = goods_SpecificationPriceRepository.GetList(new RB_Goods_SpecificationPrice_Extend() { GoodsIds = goodsIds, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                var slist = goods_SpecificationRepository.GetList(new RB_Goods_Specification_Extend() { GoodsIds = goodsIds, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                var svlist = goods_SpecificationValueRepository.GetList(new RB_Goods_SpecificationValue_Extend() { GoodsIds = goodsIds, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });

                var sslist = smallShops_PriceRepository.GetList(new RB_SmallShops_Price_Extend() { GoodsIds = goodsIds, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });

                foreach (var item in goodsList)
                {
                    var model = glist.Where(x => x.Id == item.GoodsId).FirstOrDefault();
                    if (model != null)
                    {
                        model.SpecificationList = new List<RB_Goods_Specification_Extend>();
                        model.SpecificationPriceList = new List<RB_Goods_SpecificationPrice_Extend>();
                        if (model.IsCustomSpecification == 1)
                        {
                            model.SpecificationList = slist.Where(x => x.GoodsId == model.Id).ToList();
                            if (model.SpecificationList.Any())
                            {
                                foreach (var qitem in model.SpecificationList)
                                {
                                    qitem.SpecificationValueList = svlist.Where(x => x.GoodsId == item.GoodsId && x.SpecificationId == qitem.Id).ToList();
                                }
                            }
                            model.SpecificationPriceList = splist.Where(x => x.GoodsId == item.GoodsId).ToList();
                        }

                        #region 组装价格
                        List<object> priceList = new List<object>();
                        if (model.IsCustomSpecification == 1)
                        {
                            if (model.SpecificationPriceList.Any() && model.SpecificationList.Any())
                            {
                                foreach (var qitem in model.SpecificationPriceList)
                                {
                                    var ssarr = qitem.SpecificationSort.Split(':');
                                    int Sort = Convert.ToInt32(ssarr[0]);
                                    List<object> attr_list = new List<object>();
                                    for (int i = 0; i < ssarr.Length; i++)
                                    {
                                        var smodel = model.SpecificationList[i];
                                        var svmodel = smodel.SpecificationValueList.Where(x => x.Sort == Convert.ToInt32(ssarr[i])).FirstOrDefault();

                                        attr_list.Add(new
                                        {
                                            attr_group_name = smodel.Name,
                                            attr_group_id = smodel.Sort,
                                            attr_id = svmodel.Id,
                                            attr_name = svmodel.Name
                                        });
                                    }
                                    //查找 设置的店铺价格
                                    var ssmodel = sslist.Where(x => x.GoodsId == item.GoodsId && x.SpecificationKey == qitem.SpecificationSort).FirstOrDefault();
                                    var ssPrice = qitem.SellingPrice ?? 0;
                                    if (ssmodel != null)
                                    {
                                        if (ssmodel.PriceType == 1)
                                        {
                                            ssPrice += Math.Ceiling(ssPrice * (ssmodel.UpPrice ?? 0) / 100);
                                        }
                                    }
                                    priceList.Add(new
                                    {
                                        GoodsId = model.Id,
                                        SpecificationKey = qitem.SpecificationSort,
                                        qitem.SellingPrice,
                                        AttrList = attr_list,
                                        SmallShopsPrice = ssPrice,
                                        SmallShopsPriceId = ssmodel?.Id ?? 0,
                                        UpPrice = ssmodel?.UpPrice ?? 0,
                                        PriceType = ssmodel?.PriceType ?? 0,
                                    });
                                }
                            }
                            RList.Add(new
                            {
                                GoodsId = model.Id,
                                model.Name,
                                model.CoverImage,
                                SpecificationList = priceList
                            });
                        }
                        else
                        {
                            //查找 设置的店铺价格
                            var ssmodel = sslist.Where(x => x.GoodsId == item.GoodsId && x.SpecificationKey == "").FirstOrDefault();
                            var ssPrice = model.SellingPrice ?? 0;
                            if (ssmodel != null)
                            {
                                if (ssmodel.PriceType == 1)
                                {
                                    ssPrice += Math.Ceiling(ssPrice * (ssmodel.UpPrice ?? 0) / 100);
                                }
                            }
                            priceList.Add(new
                            {
                                GoodsId = model.Id,
                                SpecificationKey = "",
                                model.SellingPrice,
                                AttrList = new List<object>(){ new
                                {
                                    attr_group_name = "规格",
                                    attr_group_id = 0,
                                    attr_id = 0,
                                    attr_name = model.DefaultSpecificationName
                                } },
                                SmallShopsPrice = ssPrice,
                                SmallShopsPriceId = ssmodel?.Id ?? 0,
                                UpPrice = ssmodel?.UpPrice ?? 0,
                                PriceType = ssmodel?.PriceType ?? 0,
                            });
                            RList.Add(new
                            {
                                GoodsId = model.Id,
                                model.Name,
                                model.CoverImage,
                                SpecificationList = priceList
                            });
                        }
                        #endregion
                    }
                }
            }

            return RList;
        }

        /// <summary>
        /// 获取商品分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public object GetSmallShopsChooseGoodsPageList(int pageIndex, int pageSize, out long count, RB_SmallShops_Price_Extend demodel)
        {
            List<object> RList = new List<object>();
            var glist = goodsRepository.GetPageList(pageIndex, pageSize, out count, new RB_Goods_Extend() { Id = demodel.GoodsId ?? 0, Name = demodel.GoodsName, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
            if (glist.Any())
            {
                //查询出所有商品id
                string goodsIds = string.Join(",", glist.Select(x => x.Id).Distinct());
                foreach (var item in glist)
                {
                    item.CoverImage = "";
                    if (!string.IsNullOrEmpty(item.CarouselImage) && item.CarouselImage != "[]")
                    {
                        List<string> CarouselIdList = JsonConvert.DeserializeObject<List<string>>(item.CarouselImage);
                        //封面图
                        item.CoverImage = CarouselIdList[0];
                    }
                }
                var splist = goods_SpecificationPriceRepository.GetList(new RB_Goods_SpecificationPrice_Extend() { GoodsIds = goodsIds, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                var slist = goods_SpecificationRepository.GetList(new RB_Goods_Specification_Extend() { GoodsIds = goodsIds, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                var svlist = goods_SpecificationValueRepository.GetList(new RB_Goods_SpecificationValue_Extend() { GoodsIds = goodsIds, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                foreach (var model in glist)
                {
                    if (model != null)
                    {
                        model.SpecificationList = new List<RB_Goods_Specification_Extend>();
                        model.SpecificationPriceList = new List<RB_Goods_SpecificationPrice_Extend>();
                        if (model.IsCustomSpecification == 1)
                        {
                            model.SpecificationList = slist.Where(x => x.GoodsId == model.Id).ToList();
                            if (model.SpecificationList.Any())
                            {
                                foreach (var qitem in model.SpecificationList)
                                {
                                    qitem.SpecificationValueList = svlist.Where(x => x.GoodsId == model.Id && x.SpecificationId == qitem.Id).ToList();
                                }
                            }
                            model.SpecificationPriceList = splist.Where(x => x.GoodsId == model.Id).ToList();
                        }

                        #region 组装价格
                        List<object> priceList = new List<object>();
                        if (model.IsCustomSpecification == 1)
                        {
                            if (model.SpecificationPriceList.Any() && model.SpecificationList.Any())
                            {
                                foreach (var qitem in model.SpecificationPriceList)
                                {
                                    var ssarr = qitem.SpecificationSort.Split(':');
                                    int Sort = Convert.ToInt32(ssarr[0]);
                                    List<object> attr_list = new List<object>();
                                    for (int i = 0; i < ssarr.Length; i++)
                                    {
                                        var smodel = model.SpecificationList[i];
                                        var svmodel = smodel.SpecificationValueList.Where(x => x.Sort == Convert.ToInt32(ssarr[i])).FirstOrDefault();

                                        attr_list.Add(new
                                        {
                                            attr_group_name = smodel.Name,
                                            attr_group_id = smodel.Sort,
                                            attr_id = svmodel.Id,
                                            attr_name = svmodel.Name
                                        });
                                    }
                                    priceList.Add(new
                                    {
                                        GoodsId = model.Id,
                                        SpecificationKey = qitem.SpecificationSort,
                                        qitem.SellingPrice,
                                        AttrList = attr_list,
                                    });
                                }
                            }
                            RList.Add(new
                            {
                                GoodsId = model.Id,
                                model.Name,
                                model.CoverImage,
                                SpecificationList = priceList
                            });
                        }
                        else
                        {
                            priceList.Add(new
                            {
                                GoodsId = model.Id,
                                SpecificationKey = "",
                                model.SellingPrice,
                                AttrList = new List<object>(){ new
                                {
                                    attr_group_name = "规格",
                                    attr_group_id = 0,
                                    attr_id = 0,
                                    attr_name = model.DefaultSpecificationName
                                } }
                            });
                            RList.Add(new
                            {
                                GoodsId = model.Id,
                                model.Name,
                                model.CoverImage,
                                SpecificationList = priceList
                            });
                        }
                        #endregion
                    }
                }
            }

            return RList;
        }

        /// <summary>
        /// 保存微店商品价格
        /// </summary>
        /// <param name="goodsId"></param>
        /// <param name="sSPList"></param>
        /// <param name="userInfo"></param>
        /// <returns></returns>
        public bool SetSmallShopsGoodsPrice(int goodsId, List<RB_SmallShops_Price_Extend> sSPList, AppletUserInfo userInfo)
        {
            var model = smallShops_InfoRepository.GetListForSingle(new RB_SmallShops_Info_Extend() { UserId = userInfo.UserId, TenantId = userInfo.TenantId, MallBaseId = userInfo.MallBaseId }).FirstOrDefault();
            if (model == null || model.AuditStatus != DistributorAuditStatusEnum.Audited)
            {
                return false;
            }
            var splist = smallShops_PriceRepository.GetList(new RB_SmallShops_Price_Extend() { SmallShopsId = model.Id, TenantId = userInfo.TenantId, MallBaseId = userInfo.MallBaseId });
            if (splist.Any())
            {
                //修改
                var insertList = sSPList.Where(x => !splist.Select(y => y.SpecificationKey).Contains(x.SpecificationKey)).ToList();
                var updateList = splist.Where(x => sSPList.Select(y => y.SpecificationKey).Contains(x.SpecificationKey)).ToList();
                var deleteList = splist.Where(x => !sSPList.Select(y => y.SpecificationKey).Contains(x.SpecificationKey)).ToList();
                foreach (var item in insertList)
                {
                    if (item.UpPrice > 0)
                    {
                        item.SmallShopsId = model.Id;
                        item.GoodsId = goodsId;
                        item.UpPrice ??= 0;
                        item.PriceType ??= 0;
                        item.Status = 0;
                        item.TenantId = userInfo.TenantId;
                        item.MallBaseId = userInfo.MallBaseId;
                        item.CreateDate = DateTime.Now;
                        item.UpdateDate = DateTime.Now;
                        smallShops_PriceRepository.Insert(item);
                    }
                }
                foreach (var item in updateList)
                {
                    var sspmodel = sSPList.Where(x => x.SpecificationKey == item.SpecificationKey).FirstOrDefault();
                    if (sspmodel.UpPrice > 0)
                    {
                        Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                            { nameof(RB_SmallShops_Price.UpPrice),sspmodel.UpPrice},
                            { nameof(RB_SmallShops_Price.PriceType),sspmodel.PriceType},
                            { nameof(RB_SmallShops_Price.UpdateDate),DateTime.Now}
                        };
                        List<WhereHelper> wheres = new List<WhereHelper>() {
                            new WhereHelper(){
                                 FiledName=nameof(RB_SmallShops_Price.Id),
                                  FiledValue=item.Id,
                                   OperatorEnum=OperatorEnum.Equal
                            }
                        };
                        smallShops_PriceRepository.Update(keyValues, wheres);
                    }
                    else
                    {
                        smallShops_PriceRepository.Delete(item);
                    }
                }
                foreach (var item in deleteList)
                {
                    smallShops_PriceRepository.Delete(item);
                }
            }
            else
            {
                foreach (var item in sSPList)
                {
                    if (item.UpPrice > 0)
                    {
                        item.SmallShopsId = model.Id;
                        item.GoodsId = goodsId;
                        item.UpPrice ??= 0;
                        item.PriceType ??= 0;
                        item.Status = 0;
                        item.TenantId = userInfo.TenantId;
                        item.MallBaseId = userInfo.MallBaseId;
                        item.CreateDate = DateTime.Now;
                        item.UpdateDate = DateTime.Now;
                        smallShops_PriceRepository.Insert(item);
                    }
                }
            }
            return true;
        }

        #endregion

        #region 微店自定义

        /// <summary>
        /// 微信自定义列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_SmallShops_Custom> GetSmallShopsCustomList(RB_SmallShops_Custom query)
        {
            return smallShopsCustomRepository.GetSmallShopsCustomList(query);
        }


        /// <summary>
        /// 设置分销自定义
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetSmallShopsCustomInfo(RB_SmallShops_Custom demodel)
        {
            var OModel = smallShopsCustomRepository.GetSmallShopsCustomList(new RB_SmallShops_Custom() { TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId }).FirstOrDefault();
            if (OModel != null)
            {
              
                Dictionary<string, object> keyValuePairs = new Dictionary<string, object>() {
                    { nameof(RB_SmallShops_Custom.HeadBackImage),demodel.HeadBackImage},
                    { nameof(RB_SmallShops_Custom.WithdrawalFilletPX),demodel.WithdrawalFilletPX},
                    { nameof(RB_SmallShops_Custom.WithdrawalText),demodel.WithdrawalText},
                    { nameof(RB_SmallShops_Custom.WithdrawalColor),demodel.WithdrawalColor},
                    { nameof(RB_SmallShops_Custom.WithdrawalTextColor),demodel.WithdrawalTextColor},
                    { nameof(RB_SmallShops_Custom.WithdrawalImage),demodel.WithdrawalImage},
                    { nameof(RB_SmallShops_Custom.SmallShopOrderName),demodel.SmallShopOrderName},
                    { nameof(RB_SmallShops_Custom.SmallShopOrderImage),demodel.SmallShopOrderImage},
                    { nameof(RB_SmallShops_Custom.WithdrawalDetailName),demodel.WithdrawalDetailName},
                    { nameof(RB_SmallShops_Custom.WithdrawalDetailImage),demodel.WithdrawalDetailImage},
                    { nameof(RB_SmallShops_Custom.MyCustomerName),demodel.MyCustomerName},
                    { nameof(RB_SmallShops_Custom.MyCustomerImage),demodel.MyCustomerImage},
                    { nameof(RB_SmallShops_Custom.SmallShopQRCodeName),demodel.SmallShopQRCodeName},
                    { nameof(RB_SmallShops_Custom.SmallShopQRCodeImage),demodel.SmallShopQRCodeImage},
                    { nameof(RB_SmallShops_Custom.SmallShopSetUpName),demodel.SmallShopSetUpName},
                    { nameof(RB_SmallShops_Custom.SmallShopSetUpImage),demodel.SmallShopSetUpImage},
                    { nameof(RB_SmallShops_Custom.LiveName),demodel.LiveName},
                    { nameof(RB_SmallShops_Custom.LiveImage),demodel.LiveImage},
                    { nameof(RB_SmallShops_Custom.CommissionWithdrawnName),demodel.CommissionWithdrawnName},
                    { nameof(RB_SmallShops_Custom.OutstandingCommissionName),demodel.OutstandingCommissionName},
                    { nameof(RB_SmallShops_Custom.WithdrawableName),demodel.WithdrawableName},
                    { nameof(RB_SmallShops_Custom.CommissionTobePaidName),demodel.CommissionTobePaidName},
                    { nameof(RB_SmallShops_Custom.UserNotesName),demodel.UserNotesName},
                    { nameof(RB_SmallShops_Custom.UserNotes),demodel.UserNotes},
                    { nameof(RB_SmallShops_Custom.IWantToWithdrawName),demodel.IWantToWithdrawName},
                    { nameof(RB_SmallShops_Custom.WithdrawalAmountName),demodel.WithdrawalAmountName},
                    { nameof(RB_SmallShops_Custom.WithdrawalWayName),demodel.WithdrawalWayName}
            };
                List<WhereHelper> whereHelpers = new List<WhereHelper>() {
                    new WhereHelper(){
                         FiledName=nameof(RB_SmallShops_Custom.Id),
                          FiledValue=OModel.Id,
                           OperatorEnum=OperatorEnum.Equal
                    },
                    new WhereHelper(){
                         FiledName=nameof(RB_SmallShops_Custom.TenantId),
                          FiledValue=OModel.TenantId,
                           OperatorEnum=OperatorEnum.Equal
                    },
                    new WhereHelper(){
                         FiledName=nameof(RB_SmallShops_Custom.MallBaseId),
                          FiledValue=OModel.MallBaseId,
                           OperatorEnum=OperatorEnum.Equal
                    }
                };
                return smallShopsCustomRepository.Update(keyValuePairs, whereHelpers);
            }
            else
            {
                return smallShopsCustomRepository.Insert(demodel) > 0;
            }
        }

        #endregion

        #region 微店订单
        /// <summary>
        /// 获取用户返佣
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_SmallShops_Commission_Extend> GetSmallShopsCommissionPageList(int pageIndex, int pageSize, out long count, RB_SmallShops_Commission_Extend dmodel)
        {
            var oclist = smallShopsCommissionRepository.GetSmallShopsCommissionPageList(pageIndex, pageSize, out count, dmodel);
            if (oclist.Any())
            {
                //获取用户
                var ulist = member_UserRepository.GetList(new RB_Member_User_Extend() { TenantId = dmodel.TenantId, MallBaseId = dmodel.MallBaseId, UserIds = string.Join(",", oclist.Select(x => x.UserId).Distinct()) });

                string orderIds = string.Join(",", oclist.Select(x => x.OrderId).Distinct());
                //查询订单明细
                var dlist = goods_OrderDetailRepository.GetOrderDetailList(new RB_Goods_OrderDetail_Extend() { TenantId = dmodel.TenantId, MallBaseId = dmodel.MallBaseId, OrderIds = orderIds });
                //查询图片
                List<RB_Material_Info_Extend> Mlist = new List<RB_Material_Info_Extend>();
                if (dlist.Any())
                {
                    foreach (var item in dlist)
                    {
                        item.CoverImagePath = item.CoverImage;
                    }
                }
                foreach (var item in oclist)
                {
                    var umodel = ulist.Where(x => x.Id == item.UserId).FirstOrDefault();
                    item.UserName = umodel?.Name ?? "";
                    item.Mobile = umodel?.Moblie ?? "";
                    item.Photo = umodel?.Photo ?? "";
                    item.OrderDetailList = new List<RB_Goods_OrderDetail_Extend>();
                    if (!string.IsNullOrWhiteSpace(item.OrderDetailIds))
                    {
                        var orderDetailIds = item.OrderDetailIds.Split(",");
                        foreach (var itemOrderDetailId in orderDetailIds)
                        {
                            if (!string.IsNullOrWhiteSpace(itemOrderDetailId))
                            {
                                item.OrderDetailList.AddRange(dlist.Where(x => x.OrderId == item.OrderId && x.Id == Convert.ToInt32(itemOrderDetailId)));
                            }
                        }
                    }
                    // item.OrderDetailList = dlist.Where(x => x.OrderId == item.OrderId).ToList();
                }
            }

            return oclist;
            // return smallShopsCommissionRepository.GetSmallShopsCommissionPageList(pageIndex, pageSize, out count, dmodel);
        }
        #endregion

        #region 微店提现

        /// <summary>
        /// 获取分销提现分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_SmallShops_Remit_Extend> GetSmallShopsRemitPageList(int pageIndex, int pageSize, out long count, RB_SmallShops_Remit_Extend demodel)
        {
            return smallShopsRemitRepository.GetPageList(pageIndex, pageSize, out count, demodel);
        }

        #endregion
    }
}
