﻿using Mall.Common.Plugin;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Mall.Common.Enum.Finance
{
    /// <summary>
    /// 模板类别针对于财务模板
    /// </summary>
    public enum WFTempLateClassEnum
    {
        /// <summary>
        /// 收入
        /// </summary>
        [EnumField("收入")]
        IN = 1,
        /// <summary>
        /// 支出 
        /// </summary>
        [EnumField("支出")]
        OUT = 2,
        /// <summary>
        /// 收支 
        /// </summary>
        [EnumField("收支")]
        INAndOUT = 3,
        /// <summary>
        /// 资金调拨 
        /// </summary>
        [EnumField("资金调拨")]
        Allot = 4,
        /// <summary>
        /// 应收 
        /// </summary>
        [EnumField("应收")]
        ShouldIncome = 5,
        /// <summary>
        /// 应付 
        /// </summary>
        [EnumField("应付")]
        ShouldPay = 6,
        /// <summary>
        /// 挂账 
        /// </summary>
        [EnumField("挂账")]
        HangingAccounts = 7,
        /// <summary>
        /// 责让 
        /// </summary>
        [EnumField("责让")]
        Responsibility = 8
    }
}
