﻿using VT.FW.DB;
using System;

namespace Mall.Model.Entity.Finance
{

    /// <summary>
    /// 公司银行账户表 实体
    /// </summary> 
    [Serializable]
    [DB(ConnectionName = "FinanceConnection")]
    public class RB_BackAccount
    {

        /// <summary>
        /// ID
        /// </summary>        
        public int ID
        {
            get;
            set;
        }
        /// <summary>
        /// 账户别名
        /// </summary>        
        public string Alias
        {
            get;
            set;
        }
        /// <summary>
        /// 账户类型
        /// </summary>        
        public int? TypeId
        {
            get;
            set;
        }
        /// <summary>
        /// 银行机构
        /// </summary>        
        public int? BackId
        {
            get;
            set;
        }
        /// <summary>
        /// 开户人
        /// </summary>        
        public string Accountholder
        {
            get;
            set;
        }
        /// <summary>
        /// 开户行
        /// </summary>
        public string Openingbank
        {
            get;set;
        }
        /// <summary>
        /// 银行卡号
        /// </summary>        
        public string BackNo
        {
            get;
            set;
        }
        /// <summary>
        /// 初始余额
        /// </summary>        
        public decimal? Initialbalance
        {
            get;
            set;
        }
        /// <summary>
        /// 账户币种
        /// </summary>        
        public int? CurrencyId
        {
            get;
            set;
        }
        /// <summary>
        /// 操作人
        /// </summary>        
        public int? CreateBy
        {
            get;
            set;
        }
        /// <summary>
        /// 操作日期
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// 集团
        /// </summary>        
        public int? RB_Group_Id
        {
            get;
            set;
        }
        /// <summary>
        /// 公司
        /// </summary>        
        public int? RB_Branch_Id
        {
            get;
            set;
        }
        /// <summary>
        /// 风险上线
        /// </summary>
        public decimal? RiskLimitMoney
        {
            get;
            set;
        }
        /// <summary>
        /// 风险下限
        /// </summary>
        public decimal? RiskLowerLimitMoney
        {
            get;set;
        }
        /// <summary>
        /// 收入负责人
        /// </summary>
        public int? InCharge
        {
            get;set;
        }
        /// <summary>
        /// 支出负责人
        /// </summary>
        public int? OutCharge
        {
            get; set;
        }
        /// <summary>
        /// 状态
        /// </summary>        
        public Common.Enum.DateStateEnum? Status
        {
            get;
            set;
        }
        /// <summary>
        /// 账户2019-01-01  初始金额
        /// </summary>
        private decimal? accountStartMoney=0;
        /// <summary>
        /// 账户2019-01-01  初始金额
        /// </summary>
        public decimal? AccountStartMoney { get => accountStartMoney; set => accountStartMoney = value; }
        /// <summary>
        /// 账户2019-01-01  初始原币金额
        /// </summary>
        private decimal? accountStartWBMoney = 0;
        /// <summary>
        /// 账户2019-01-01  初始原币金额
        /// </summary>
        public decimal? AccountStartWBMoney { get => accountStartWBMoney; set => accountStartWBMoney = value; }

        /// <summary>
        /// 期初应用时间
        /// </summary>
        public DateTime? BeginTime { get; set; }

    }
}