﻿using VT.FW.DB;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.Product
{
    /// <summary>
    /// 商品推荐设置表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Product_Recommend
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 商品详情页面推荐状态  1开启  2禁止
        /// </summary>        
        public int? DetailRecommendStatus
        {
            get;
            set;
        }
        /// <summary>
        /// 是否优先推荐同类商品   1是  2否
        /// </summary>
        public int? DetailRecommendSame { get; set; }
        /// <summary>
        /// 推荐数量
        /// </summary>        
        public int? DetailRecommendNum
        {
            get;
            set;
        }
        /// <summary>
        /// 订单完成后推荐状态  1开启  2禁止
        /// </summary>        
        public int? OrderCompleteStatus
        {
            get;
            set;
        }
        /// <summary>
        /// 是否自定义  1是  2否
        /// </summary>        
        public int? IsOrderRecommend
        {
            get;
            set;
        }
        /// <summary>
        /// 自定义商品ids  逗号分隔
        /// </summary>        
        public string OrderProductIds
        {
            get;
            set;
        }
        /// <summary>
        /// 评论后推荐商品状态  1开启  2禁止
        /// </summary>        
        public int? CommentRecommentStatus
        {
            get;
            set;
        }
        /// <summary>
        /// 评论后自定义推荐商品  1是  2否
        /// </summary>        
        public int? IsCommentRecommend
        {
            get;
            set;
        }
        /// <summary>
        /// 评论后推荐商品ids 逗号分隔
        /// </summary>        
        public string CommentProductIds
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// UpdateDate
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }
    }
}
