﻿using Mall.Model.Entity.MarketingCenter;
using Mall.Model.Extend.User;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.User
{
    public class RB_Member_CouponProductRepository : RepositoryBase<RB_Member_CouponProduct>
    {

        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_DiscountCoupon_Product); } }

        /// <summary>
        /// 表名称
        /// </summary>
        public string PCategoryTableName { get { return nameof(Model.Entity.Product.RB_Product_Category); } }

        /// <summary>
        /// 表名称
        /// </summary>
        public string GoodsTableName { get { return nameof(Model.Entity.Product.RB_Goods); } }
        /// <summary>
        /// 优惠券对应的商品/分类列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Member_CouponProduct_Extend> GetMemberCouponProduct(RB_Member_DiscountCoupon_Extend query, string DiscountCouponIds)
        {
            StringBuilder builder = new StringBuilder();

            if (query != null)
            {

                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Member_CouponProduct.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Member_CouponProduct.MallBaseId)}={query.MallBaseId}");
                }
            }
            if (!string.IsNullOrWhiteSpace(DiscountCouponIds))
            {
                builder.Append($" AND a.{nameof(RB_Member_CouponProduct.MemberCouponId)} in ({DiscountCouponIds})");
            }
            string sql = $"SELECT a.* from {TableName} as a  WHERE a.{nameof(RB_Member_CouponProduct.Status)}=0 {builder.ToString()}  ";
            if (query.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Category)
            {
                sql = $" SELECT a.*,b.`Name` as Relevance from {TableName} as a LEFT JOIN {PCategoryTableName} as b on a.ProductId=b.Id WHERE a.{nameof(RB_Member_CouponProduct.Status)}=0 {builder.ToString()} ";
            }
            else if (query.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Product)
            {
                sql = $" SELECT a.*,b.`Name` as Relevance from {TableName} as a LEFT JOIN {PCategoryTableName} as b on a.ProductId=b.Id WHERE a.{nameof(RB_Member_CouponProduct.Status)}=0 {builder.ToString()} ";
            }
            return Get<RB_Member_CouponProduct_Extend>(sql).ToList();
        }
    }
}
