﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Plugin;

namespace Mall.Common.Enum.TradePavilion
{
    /// <summary>
    /// 品牌下载枚举列表
    /// </summary>
    public enum BusinessExportEnum
    {
        /// <summary>
        /// 品牌分类
        /// </summary>
        [EnumField("品牌分类")]
        ClassName = 1,
        /// <summary>
        /// 品牌全名
        /// </summary>
        [EnumField("品牌全名")]
        FullBrandName = 2,
        /// <summary>
        /// 品牌名
        /// </summary>
        [EnumField("品牌名")]
        BrandName = 3,
        /// <summary>
        /// Logo
        /// </summary>
        [EnumField("Logo")]
        Logo = 4,
       
        /// <summary>
        /// 品牌视频
        /// </summary>
        [EnumField("品牌视频")]
        VideoUrl = 5,
        /// <summary>
        /// 店铺数量
        /// </summary>
        [EnumField("店铺数量")]
        ShopNum = 6,
        /// <summary>
        /// 建筑面积
        /// </summary>
        [EnumField("建筑面积")]
        BuiltUpArea = 7,
        /// <summary>
        /// 需求面积
        /// </summary>
        [EnumField("需求面积")]
        AreaRequirement = 8,
        /// <summary>
        /// 客群定位
        /// </summary>
        [EnumField("客群定位")]
        CustomerType = 9,
        /// <summary>
        /// 品牌定位
        /// </summary>
        [EnumField("品牌定位")]
        BrandType = 10,
        /// <summary>
        /// 拓店区域
        /// </summary>
        [EnumField("拓店区域")]
        StoreExpansion = 11,
        /// <summary>
        /// 商铺性质
        /// </summary>
        [EnumField("商铺性质")]
        ProjectType = 12,
        /// <summary>
        /// 店铺开口尺寸
        /// </summary>
        [EnumField("店铺开口尺寸")]
        IsShopSize = 13,
        /// <summary>
        /// 燃气
        /// </summary>
        [EnumField("燃气")]
        RanQi = 14,
        /// <summary>
        /// 排烟量
        /// </summary>
        [EnumField("排烟量")]
        PaiYan = 15,
        /// <summary>
        /// 电量
        /// </summary>
        [EnumField("电量")]
        IsDianLiang = 16,
        /// <summary>
        /// 上下水
        /// </summary>
        [EnumField("上下水")]
        Plumbing = 17,
        /// <summary>
        /// 管径
        /// </summary>
        [EnumField("管径")]
        Caliber = 18,
        /// <summary>
        /// 排污
        /// </summary>
        [EnumField("排污")]
        Sewage = 19,
        /// <summary>
        /// 空调
        /// </summary>
        [EnumField("空调")]
        KongTiao = 20,
        /// <summary>
        /// 新风
        /// </summary>
        [EnumField("新风")]
        XinFeng = 21,
        /// <summary>
        /// 广告
        /// </summary>
        [EnumField("广告")]
        Advertising = 22,
        /// <summary>
        /// 其他
        /// </summary>
        [EnumField("其他")]
        Other = 23,
       
    }


    /// <summary>
    /// 【商载通】品牌、企业服务下载枚举列表
    /// </summary>
    public enum BrandEnterpriseExportEnum
    {
        /// <summary>
        /// 分类
        /// </summary>
        [EnumField("分类")]
        CategoryId = 1,
        /// <summary>
        /// 品牌全名
        /// </summary>
        [EnumField("品牌全名")]
        FullBrandName = 2,
        /// <summary>
        /// 品牌名
        /// </summary>
        [EnumField("品牌名")]
        BrandName = 3,
        /// <summary>
        /// Logo
        /// </summary>
        [EnumField("Logo")]
        Logo = 4,

        /// <summary>
        /// 品牌视频
        /// </summary>
        [EnumField("品牌视频")]
        VideoUrl = 5,
        /// <summary>
        /// 店铺数量
        /// </summary>
        [EnumField("店铺数量")]
        ShopNum = 6,
        /// <summary>
        /// 建筑面积
        /// </summary>
        [EnumField("建筑面积")]
        BuiltUpArea = 7,
        /// <summary>
        /// 需求面积
        /// </summary>
        [EnumField("需求面积")]
        AreaRequirement = 8,
        /// <summary>
        /// 客群定位
        /// </summary>
        [EnumField("客群定位")]
        CustomerType = 9,
        /// <summary>
        /// 品牌定位
        /// </summary>
        [EnumField("品牌定位")]
        BrandType = 10,

        /// <summary>
        /// 简介
        /// </summary>
        [EnumField("简介")]
        Introduce =11,

        /// <summary>
        /// 发展意向
        /// </summary>
        [EnumField("发展意向")]
        DevIntention = 12,

        /// <summary>
        /// 物业需求
        /// </summary>
        [EnumField("物业需求")]
        PropertyDemand = 13,

        /// <summary>
        /// 合作条件
        /// </summary>
        [EnumField("合作条件")]
        Cooperation =14,

        /// <summary>
        /// 配套需求
        /// </summary>
        [EnumField("配套需求")]
        Complementary =15
    }
}
