﻿using System;
using Mall.Common;
using Newtonsoft.Json;

namespace Mall.WeChat.Common
{
    /// <summary>
    /// 微信配置实体类
    /// </summary>
    public class WeChatSetting
    {
        #region 公众号设置
        /// <summary>
        /// 公众号名称
        /// </summary>
        public string sAccountName { get; set; }

        /// <summary>
        /// 微信原始ID
        /// </summary>
        public string sAccountID { get; set; }

        /// <summary>
        /// 微信绑定Token
        /// </summary>
        public string sToken { get; set; }

        /// <summary>
        /// 微信开发者绑定Url地址
        /// </summary>
        public string sUrl { get; set; }

        /// <summary>
        /// AppId（应用ID）
        /// </summary>
        public string sAppId { get; set; }

        /// <summary>
        /// sAppSecret（应用密钥）
        /// </summary>
        public string sAppSecret { get; set; }

        /// <summary>
        /// 商户号
        /// </summary>
        public string sMchId { get; set; }

        /// <summary>
        /// API秘钥
        /// </summary>
        public string sPaySignKey { get; set; }

        /// <summary>
        /// 微信支付回调地址
        /// </summary>
        public string sTenpayNotify { get; set; }

        /// <summary>
        /// 微信支付发起支付地址
        /// </summary>
        public string sSendUrl { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public string sCertPath { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public string sCertPwd { get; set; }

        #endregion

        #region 开放平台设置

        /// <summary>
        /// 
        /// </summary>
        public string sOpenName { get; set; }

        /// <summary>
        /// APPkey
        /// </summary>
        public string sOpenAppID { get; set; }

        /// <summary>
        /// APP密钥
        /// </summary>
        public string sOpenAppSecret { get; set; }

        /// <summary>
        /// 商户号
        /// </summary>
        public string sOpenMchID { get; set; }

        /// <summary>
        /// API密钥
        /// </summary>
        public string sOpenKey { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public string sOpenCertPath { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public string sOpenCertPwd { get; set; }
        #endregion
    }

    /// <summary>
    /// 通用配置，可以修改为其它方式存储这些配置。
    /// </summary>
    public class WeChatConfig
    {
        /// <summary>
        /// 微信配置
        /// </summary>
        public static WeChatSetting Setting { get; set; }

        /// <summary>
        /// 初始化配置
        /// </summary>
        public static void InitConfig()
        {
            try
            {
                string confirmingStr = Config.APPPay;
                Setting = JsonConvert.DeserializeObject<WeChatSetting>(confirmingStr);
            }
            catch(Exception ex)
            {
                throw ex;
            }
            
        }

        #region 公众号配置
        
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public static string GetAppId()
        {
            if (Setting == null)
                InitConfig();
            return Setting.sAppId;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public static string GetMchId()
        {
            if (Setting == null)
                InitConfig();
            return Setting.sMchId;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public static string GetKey()
        {
            if (Setting == null)
                InitConfig();
            return Setting.sPaySignKey;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public static string GetCertPath()
        {
            if (Setting == null)
                InitConfig();
            return Setting.sCertPath;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public static string GetCertPwd()
        {
            if (Setting == null)
                InitConfig();
            return Setting.sCertPwd;
        }
        /// <summary>
        /// 获取web.config的WeChatSecret
        /// </summary>
        /// <returns></returns>
        public static string GetSecret()
        {
            if (Setting == null)
                InitConfig();
            return Setting.sAppSecret;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public static string GetNotify()
        {
            if (Setting == null)
                InitConfig();
            return Setting.sTenpayNotify;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public static string GetToken()
        {
            if (Setting == null)
                InitConfig();
            return Setting.sToken;
        }
        #endregion

        #region 第三方开放平台配置
        /// <summary>
        /// 获取OpenAppId
        /// </summary>
        /// <returns></returns>
        public static string GetOpenAppId()
        {
            if (Setting == null)
                InitConfig();
            return Setting.sOpenAppID;
        }

        /// <summary>
        /// 获取OpenMchID
        /// </summary>
        /// <returns></returns>
        public static string GetOpenMchID()
        {
            if (Setting == null)
                InitConfig();
            return Setting.sOpenMchID;
            //return WebConfigurationManager.AppSettings["OpenAppSecret"];
        }

        /// <summary>
        /// 获取OpenKey
        /// </summary>
        /// <returns></returns>
        public static string GetOpenKey()
        {
            if (Setting == null)
                InitConfig();
            return Setting.sOpenKey;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public static string GetOpenToken()
        {
            return WebConfigurationManager.AppSettings["OpenToken"];
        }
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public static string GetOpenDesKey()
        {
            return WebConfigurationManager.AppSettings["OpenDESKey"];
        }
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public static string GetOpenCertPath()
        {
            if (Setting == null)
                InitConfig();
            return Setting.sOpenCertPath;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public static string GetOpenCertPwd()
        {
            if (Setting == null)
                InitConfig();
            return Setting.sOpenCertPwd;
        }
        #endregion


    }
}
