﻿using VT.FW.DB;
using Mall.Common.Enum.Goods;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.Product
{
    /// <summary>
    /// 活动表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Goods_Activity
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 活动名称
        /// </summary>        
        public string ActivityName
        {
            get;
            set;
        }

        /// <summary>
        /// 活动参加层级  0表示  全部 
        /// </summary>
        public int Tier { get; set; }

        /// <summary>
        /// 类型  1订单数量    2订单金额    3商品数量
        /// </summary>
        public int Type { get; set; }

        /// <summary>
        /// 订单数量
        /// </summary>
        public int OrderNum { get; set; }

        /// <summary>
        /// 订单金额
        /// </summary>
        public decimal OrderMoney { get; set; }

        /// <summary>
        /// 商品数量
        /// </summary>
        public int GoodsNum { get; set; }

        /// <summary>
        /// 范围类型  1分类   2指定商品
        /// </summary>
        public int RangeType { get; set; }

        /// <summary>
        /// 范围Ids  英文逗号分隔
        /// </summary>
        public string RangeIds { get; set; }

        /// <summary>
        /// 领取方式   1线上   2线下
        /// </summary>
        public int Way { get; set; }

        /// <summary>
        /// 验证码长度
        /// </summary>
        public int CodeLength { get; set; }

        /// <summary>
        /// 奖品名称
        /// </summary>
        public string PrizeName { get; set; }

        /// <summary>
        /// 奖品图片
        /// </summary>
        public string PrizeImage { get; set; }

        /// <summary>
        /// 活动开始时间
        /// </summary>
        public DateTime StartTime { get; set; }

        /// <summary>
        /// 活动结束时间
        /// </summary>
        public DateTime EndTime { get; set; }

        /// <summary>
        /// 封面图
        /// </summary>
        public string CoverImage { get; set; }

        /// <summary>
        /// 描述
        /// </summary>
        public string Description { get; set; }

        /// <summary>
        /// 兑换期限
        /// </summary>
        public DateTime ReceiveTime { get; set; }

        /// <summary>
        /// 是否启用  1是  2否
        /// </summary>
        public int Enable { get; set; }

        /// <summary>
        /// 删除状态
        /// </summary>        
        public int Status
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// UpdateDate
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }

        /// <summary>
        /// 活动对象   1分销商   2所有用户
        /// </summary>
        public int ActiveObject { get; set; }
    }
}
