﻿using Mall.Common.Enum;
using System;
using VT.FW.DB;

namespace Mall.Model.Entity.TradePavilion
{
    /// <summary>
    /// 企业服务实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_EnterpriseServices
    {
        /// <summary>
		/// 企业服务主键Id
		/// </summary>
		public int ServiceId { get; set; }

        /// <summary>
        /// 企业名称
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 企业图片
        /// </summary>
        public string Banner { get; set; }

        /// <summary>
        /// 企业简介
        /// </summary>
        public string Introduction { get; set; }

        /// <summary>
        /// 企业发展意向
        /// </summary>
        public string DevIntention { get; set; }

        /// <summary>
        /// 楼宇位置
        /// </summary>
        public string Address { get; set; }

        /// <summary>
        /// 经纬度
        /// </summary>
        public string LatAndLon { get; set; }

        /// <summary>
        /// 投运时间
        /// </summary>
        public string OperationTime { get; set; }

        /// <summary>
        /// 企业分类
        /// </summary>
        public int CategoryId { get; set; }

        /// <summary>
        /// 楼宇装修
        /// </summary>
        public string Renovation { get; set; }

        /// <summary>
        /// 支付方式
        /// </summary>
        public string Payment { get; set; }

        /// <summary>
        /// 交房日期
        /// </summary>
        public string HandoverDate { get; set; }

        /// <summary>
        /// 意向楼层
        /// </summary>
        public string IntentionalFloor { get; set; }

        /// <summary>
        /// 电梯数
        /// </summary>
        public string ElevatorNum { get; set; }

        /// <summary>
        /// 物业费(元/㎡)
        /// </summary>
        public decimal PropertyFee { get; set; }

        /// <summary>
        /// 月租金(元/㎡)
        /// </summary>
        public decimal RentFee { get; set; }

        /// <summary>
        /// 联系人
        /// </summary>
        public string ContactName { get; set; }

        /// <summary>
        /// 联系电话
        /// </summary>
        public string ContactPhone { get; set; }

        /// <summary>
        /// 商户号id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }

        /// <summary>
        /// 创建人
        /// </summary>
        public int CreateBy { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime CreateDate { get; set; }

        /// <summary>
        /// 修改人
        /// </summary>
        public int UpdateBy { get; set; }

        /// <summary>
        /// 小程序用户id
        /// </summary>
        public int UserId { get; set; }

        /// <summary>
        /// 修改时间
        /// </summary>
        public DateTime UpdateDate { get; set; }

        /// <summary>
        /// 删除状态
        /// </summary>
        public DateStateEnum Status { get; set; }

        /// <summary>
        /// 楼宇等级
        /// </summary>
        public int EType { get; set; }
    }
}
