﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Common.Enum;
using Mall.Model.Entity.Coffee;
using Mall.Model.Extend.Coffee;

namespace Mall.Repository.Coffee
{
    public class RB_Member_CoffeeLogRepository : BaseRepository<RB_Member_CoffeeLog>
    {
        /// <summary>
        /// 获取咖啡劵列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Member_CoffeeLog_Extend> GetPageList(int pageIndex,int pageSize, out long count,RB_Member_CoffeeLog_Extend query)
        {

            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM RB_Member_CoffeeLog
WHERE 1=1
");
            if (query != null)
            {
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Member_CoffeeLog_Extend.MallBaseId), query.MallBaseId);
                }
                if (query.UserId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Member_CoffeeLog_Extend.UserId), query.UserId);
                }
                if (query.Type > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Member_CoffeeLog_Extend.Type), query.Type);
                }
                if (query.BuyType > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Member_CoffeeLog_Extend.BuyType), query.BuyType);
                }
                if (!string.IsNullOrEmpty(query.StartTime))
                {
                    builder.AppendFormat(" AND {0} >='{1}' ", nameof(RB_Member_CoffeeLog_Extend.CreateDate), query.StartTime);
                }
                if (!string.IsNullOrEmpty(query.EndTime))
                {
                    builder.AppendFormat(" AND {0} <='{1} 23:59:59' ", nameof(RB_Member_CoffeeLog_Extend.CreateDate), query.EndTime);
                }
            }
            builder.AppendFormat(" order by Id desc");
            return GetPage<RB_Member_CoffeeLog_Extend>(pageIndex, pageSize, out count, builder.ToString()).ToList();
        }

        /// <summary>
        /// 获取咖啡劵列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Member_CoffeeLog_Extend> GetList(RB_Member_CoffeeLog_Extend query)
        {

            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM RB_Member_CoffeeLog
WHERE 1=1
");
            if (query == null)
            {
                return new List<RB_Member_CoffeeLog_Extend>();
            }
            else
            {
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Member_CoffeeLog_Extend.MallBaseId), query.MallBaseId);
                }
                if (query.UserId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Member_CoffeeLog_Extend.UserId), query.UserId);
                }
                if (query.Type > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Member_CoffeeLog_Extend.Type), query.Type);
                }
                if (!string.IsNullOrEmpty(query.Code))
                {
                    builder.AppendFormat(" AND {0}='{1}' ", nameof(RB_Member_CoffeeLog_Extend.Code), query.Code);
                }
            }
            return Get<RB_Member_CoffeeLog_Extend>(builder.ToString()).ToList();
        }

        /// <summary>
        /// 获取咖啡劵 日报表
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Member_CoffeeLog_Extend> GetCoffeeStatisticsToDay(RB_Member_CoffeeLog_Extend demodel, int type)
        {
            string DateStr = "DATE_FORMAT(c.CreateDate,'%Y-%m-%d')";
            if (type == 2)
            {
                DateStr = "DATE_FORMAT(c.CreateDate,'%Y-%m')";
            }
            else if (type == 3) {
                DateStr = "DATE_FORMAT(c.CreateDate,'%Y')";
            }
            string sql = $@"SELECT e1.EduSellId as CreateBy,{DateStr} as Date,
SUM(case when e.Id is null and c.BuyType =1 then c.Number else 0 end) AS LBFreeNum,
SUM(case when e.Id is null and c.BuyType =2 then c.Number else 0 end) AS LBBuyNum,
SUM(case when (e.Type =1 or (e.Type =2 and e.StuIsEmp =1)) and c.BuyType =1 then c.Number else 0 end) AS EmpFreeNum,
SUM(case when (e.Type =1 or (e.Type =2 and e.StuIsEmp =1)) and c.BuyType =2 then c.Number else 0 end) AS EmpBuyNum,
SUM(case when e.Type =2 and e.StuIsEmp =0 and c.BuyType =1 then c.Number else 0 end) AS StuFreeNum,
SUM(case when e.Type =2 and e.StuIsEmp =0 and c.BuyType =2 then c.Number else 0 end) AS StuBuyNum
 FROM rb_member_coffeelog c
INNER JOIN rb_education_edusell e1 on c.CreateBy = e1.UserId
LEFT JOIN rb_education_edusell e on c.UserId = e.UserId
WHERE c.MallBaseId ={demodel.MallBaseId} and c.CreateDate >='{demodel.StartTime}' and c.CreateDate <='{demodel.EndTime} 23:59:59'
GROUP BY e1.EduSellId,{DateStr}
";
            return Get<RB_Member_CoffeeLog_Extend>(sql).ToList();
        }

        /// <summary>
        /// 收款
        /// </summary>
        /// <param name="demodel"></param>
        /// <param name="type"></param>
        /// <returns></returns>
        public List<RB_Member_CoffeeLog_Extend> GetCoffeeMoneyStatisticsToDay(RB_Member_CoffeeLog_Extend demodel, int type)
        {
            string DateStr = "DATE_FORMAT(c.CreateDate,'%Y-%m-%d')";
            if (type == 2)
            {
                DateStr = "DATE_FORMAT(c.CreateDate,'%Y-%m')";
            }
            else if (type == 3)
            {
                DateStr = "DATE_FORMAT(c.CreateDate,'%Y')";
            }
            string sql = $@"SELECT {DateStr} as Date, SUM(o.Income) AS Income
 FROM rb_member_coffeelog c
INNER JOIN rb_goods_order o on c.OrderId = o.OrderId
WHERE c.MallBaseId ={demodel.MallBaseId} and c.CreateDate >='{demodel.StartTime}' and c.CreateDate <='{demodel.EndTime} 23:59:59'
GROUP BY {DateStr}";
            return Get<RB_Member_CoffeeLog_Extend>(sql).ToList();
        }

    }
}
