﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.Coffee;
using Mall.Model.Extend.Education;

namespace Mall.Repository.Education
{

    /// <summary>
    /// 教育商品仓储
    /// </summary>
    public class RB_EduGoodsRepository : BaseRepository<RB_Goods>
    {
        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Goods_ViewModel> GetList(RB_Goods_ViewModel demodel)
        {
            string where = $@" 1=1 and Status =0";

            if (demodel.Group_Id > 0)
            {
                where += $@" and {nameof(RB_Goods_ViewModel.Group_Id)} ={demodel.Group_Id}";
            }
            if (demodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Goods_ViewModel.MallBaseId)} ={demodel.MallBaseId}";
            }
            if (demodel.GoodsType > 0)
            {
                where += $@" and {nameof(RB_Goods_ViewModel.GoodsType)} ={demodel.GoodsType}";
            }
            if (demodel.MallGoodsId > 0)
            {
                where += $@" and {nameof(RB_Goods_ViewModel.MallGoodsId)} ={demodel.MallGoodsId}";
            }
            if (!string.IsNullOrEmpty(demodel.MallGoodsIds))
            {
                where += $@" and {nameof(RB_Goods_ViewModel.MallGoodsId)} in({demodel.MallGoodsIds})";
            }
            if (!string.IsNullOrEmpty(demodel.GoodsIds))
            {
                where += $@" and {nameof(RB_Goods_ViewModel.Id)} in({demodel.GoodsIds})";
            }

            string sql = $@" select * from RB_Goods where {where} order by Id desc";
            return Get<RB_Goods_ViewModel>(sql).ToList();
        }
    }
}
