﻿using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 拼团活动商品关联分销佣金表仓储层
    /// </summary>
    public class RB_GroupBuy_DistributioncommissionRepository : BaseRepository<RB_GroupBuy_Distributioncommission>
    {
        /// <summary>
        /// 获取拼团活动商品分销佣金
        /// </summary>
        /// <returns></returns>
        public List<RB_GroupBuy_Distributioncommission_Extend> GetGroupBuyCommissionRepository(RB_GroupBuy_Distributioncommission_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(@" SELECT * FROM RB_GroupBuy_Distributioncommission WHERE 1=1 ");
            if (query != null)
            {
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_GroupBuy_Distributioncommission_Extend.MallBaseId), query.MallBaseId);
                }
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_GroupBuy_Distributioncommission_Extend.TenantId), query.TenantId);
                }
                if (query.GoodsId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_GroupBuy_Distributioncommission_Extend.GoodsId), query.GoodsId);
                }
                if (!string.IsNullOrWhiteSpace(query.GoodIds))
                {
                    builder.AppendFormat(" AND {0} IN({1}) ", nameof(RB_GroupBuy_Distributioncommission_Extend.GoodsId), query.GoodIds);
                }
            }
            return Get<RB_GroupBuy_Distributioncommission_Extend>(builder.ToString()).ToList();
        }
    }
}
