﻿using Mall.Model.Entity.Reserve;
using Mall.Model.Entity.MarketingCenter;
using Mall.Model.Extend.Reserve;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.Reserve
{
    public class RB_Reserve_CouponProductRepository : BaseRepository<RB_Reserve_CouponProduct>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Reserve_CouponProduct); } }

        /// <summary>
        /// 表名称
        /// </summary>
        public string PCategoryTableName { get { return nameof(Model.Entity.Product.RB_Product_Category); } }

        /// <summary>
        /// 表名称
        /// </summary>
        public string GoodsTableName { get { return nameof(Model.Entity.Product.RB_Goods); } }

        /// <summary>
        /// 优惠券对应的商品/分类列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_CouponProduct> GetCouponProductList(RB_Reserve_CouponProduct query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE {nameof(RB_Reserve_CouponProduct.Status)}=0 ");
            if (query != null)
            {
                if (query.ID > 0)
                {
                    builder.Append($" AND {nameof(RB_Reserve_CouponProduct.ID)}={query.ID}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Reserve_CouponProduct.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Reserve_CouponProduct.MallBaseId)}={query.MallBaseId}");
                }
                if (query.CouponId > 0)
                {
                    builder.Append($" AND {nameof(RB_Reserve_CouponProduct.CouponId)}={query.CouponId}");
                }
            }
            return Get<RB_Reserve_CouponProduct>(builder.ToString()).ToList();
        }

        /// <summary>
        /// 优惠券对应的商品/分类列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_CouponProduct_Extend> GetListByDiscountCouponIds(RB_Reserve_Coupon query, string DiscountCouponIds,bool IsSelectDel =false)
        {
            StringBuilder builder = new StringBuilder();

            if (query != null)
            {
                
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_CouponProduct.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_CouponProduct.MallBaseId)}={query.MallBaseId}");
                }
            }
            if (!string.IsNullOrWhiteSpace(DiscountCouponIds))
            {
                builder.Append($" AND a.{nameof(RB_Reserve_CouponProduct.CouponId)} in ({DiscountCouponIds})");
            }
            string sql = "";
            if (IsSelectDel)
            {
                sql = $"SELECT a.* from {TableName} as a  WHERE 1=1 ";
            }
            else {
                sql = $"SELECT a.* from {TableName} as a  WHERE a.{nameof(RB_Reserve_CouponProduct.Status)}=0 {builder.ToString()}  ";
            }            
            if (query.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Category)
            {
                sql = $" SELECT a.*,b.`Name` as Relevance from {TableName} as a LEFT JOIN {PCategoryTableName} as b on a.ProductId=b.Id WHERE a.{nameof(RB_Reserve_CouponProduct.Status)}=0 {builder.ToString()} ";
            }
            else if (query.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Product)
            {
                sql = $" SELECT a.*,b.`Name` as Relevance from {TableName} as a LEFT JOIN {GoodsTableName} as b on a.ProductId=b.Id WHERE a.{nameof(RB_Reserve_CouponProduct.Status)}=0 {builder.ToString()} ";
            }
            return Get<RB_Reserve_CouponProduct_Extend>(sql).ToList();
        }
    }
}
