﻿using System;
using System.Collections.Generic;

namespace AdapaySDK
{
    public class StringUtils
    {
        public static string tryGetNotNullValue(Dictionary<string, object> dict, string key) {
            object value = null;
            dict.TryGetValue(key, out value);
            if (String.IsNullOrWhiteSpace((string)value))
            {
                throw new Exception(value + " cannot be empty");
            }
            return (string)value;

        }

        /// <summary>
        /// 获取时间
        /// </summary>
        /// <returns></returns>        
        public static string timeStamp()
        {
            DateTime startTime = new DateTime(1970, 1, 1, 0, 0, 0, 0);
            DateTime localNow = DateTime.Now;
            long timeStamp = (long)((localNow - startTime).TotalMilliseconds);
            return "" + timeStamp;
        }

        /// <summary>
        /// 时间戳反转为时间，有很多中翻转方法，但是，请不要使用过字符串（string）进行操作，大家都知道字符串会很慢！
        /// </summary>
        /// <param name="TimeStamp">时间戳</param>
        /// <param name="AccurateToMilliseconds">是否精确到毫秒</param>
        /// <returns>返回一个日期时间</returns>
        public static DateTime GetTime(long TimeStamp, bool AccurateToMilliseconds = false)
        {
            System.DateTime startTime = TimeZone.CurrentTimeZone.ToLocalTime(new System.DateTime(1970, 1, 1)); // 当地时区
            if (AccurateToMilliseconds)
            {
                return startTime.AddTicks(TimeStamp * 10000);
            }
            else
            {
                return startTime.AddTicks(TimeStamp * 10000000);
            }
        }
    }
}
