﻿using COSXML;
using COSXML.Auth;
using COSXML.Model.Object;
using COSXML.Model.Bucket;
using COSXML.CosException;
using Newtonsoft.Json.Linq;
using System.IO;
using COSXML.Utils;
using System.Collections.Generic;
using System;

namespace Mall.ThirdCore.Oss
{
    /// <summary>
    /// 腾讯OSS服务
    /// </summary>
    public class TencentOss: IOssService
    {
        private string endpoint = "";
        private string accessKeyId = "";
        private string accessKeySecret = "";
        private string bucketName = "";
        /// <summary>
        /// 文件存储位置
        /// </summary>
        private string fileStoragePath = "";

        /// <summary>
        /// 构造函数
        /// </summary>
        /// <param name="endpoint"></param>
        /// <param name="accessKeyId"></param>
        /// <param name="accessKeySecret"></param>
        /// <param name="bucketName"></param>
        /// <param name="fileStoragePath">文件存储位置</param>
        public TencentOss(string endpoint, string accessKeyId, string accessKeySecret, string bucketName, string fileStoragePath)
        {
            this.endpoint = endpoint;
            this.accessKeyId = accessKeyId;
            this.accessKeySecret = accessKeySecret;
            this.bucketName = bucketName;
            this.fileStoragePath = fileStoragePath;
        }

        /// <summary>
        /// 创建实例
        /// </summary>
        /// <returns></returns>
        public static TencentOss Instance(string endpoint, string accessKeyId, string accessKeySecret, string bucketName,string fileStoragePath)
        {
            endpoint ??= "ap-chengdu";
            accessKeyId ??= "AKIDDPnbIzi8C1eqEOPP8dw6MNAg9H9ldDKd";
            accessKeySecret ??= "PdcLtOjslUzNFYdU4OSI1fKtdHpFT2Ob";
            bucketName ??= "viitto-1301420277";
            fileStoragePath ??= "/SaleBefore/Goods/";
            return new TencentOss(endpoint, accessKeyId, accessKeySecret, bucketName, fileStoragePath);
        }

        /// <summary>
        /// 上传文件
        /// </summary>
        /// <param name="filePath">文件名</param>
        /// <param name="stream">文件流</param>
        /// <returns></returns>
        public OssResult UploadFile(string filePath, System.IO.Stream stream)
        {
            OssResult ossResult = new OssResult();
            CosXmlConfig config = new CosXmlConfig.Builder()
   .SetConnectionTimeoutMs(60000)  //设置连接超时时间，单位毫秒，默认45000ms
   .SetReadWriteTimeoutMs(40000)  //设置读写超时时间，单位毫秒，默认45000ms
   .IsHttps(true)  //设置默认 HTTPS 请求
   //.SetAppid("1301420277") //设置腾讯云账户的账户标识 APPID
   .SetRegion(this.endpoint) //设置一个默认的存储桶地域
   .Build();

            string secretId = this.accessKeyId;   //云 API 密钥 SecretId
            string secretKey =this.accessKeySecret; //云 API 密钥 SecretKey
            long durationSecond = 600;          //每次请求签名有效时长，单位为秒
            QCloudCredentialProvider qCloudCredentialProvider = new DefaultQCloudCredentialProvider(secretId,
              secretKey, durationSecond);
            CosXml cosXml = new CosXmlServer(config, qCloudCredentialProvider);
            try
            {
                string fileExtention = System.IO.Path.GetExtension(filePath);
                string bucket = this.bucketName; //存储桶，格式：BucketName-APPID
                string key = fileStoragePath + DateTime.Now.Ticks.ToString() + fileExtention; //对象在存储桶中的位置，即称对象键
                PutObjectRequest request = new PutObjectRequest(bucket, key, filePath);
                //设置签名有效时长
                request.SetSign(TimeUtils.GetCurrentTime(TimeUnit.SECONDS), 600);
                //设置进度回调
                request.SetCosProgressCallback(delegate (long completed, long total)
                {
                    //Console.WriteLine(String.Format("progress = {0:##.##}%", completed * 100.0 / total));
                });
                //执行请求
                PutObjectResult result = cosXml.PutObject(request);
                //对象的 eTag
                ossResult.data = key;
                ossResult.resultCode = 1;
                ossResult.message = "上传成功";
            }
            catch (COSXML.CosException.CosClientException clientEx)
            {
                ossResult.resultCode = 0;
                ossResult.message = clientEx.Message;
            }
            catch (COSXML.CosException.CosServerException serverEx)
            {
                ossResult.resultCode = 0;
                ossResult.message = serverEx.Message;
            }
            return ossResult;
        }

        /// <summary>
        /// 删除文件
        /// </summary>
        /// <param name="fileName"></param>
        /// <returns></returns>
        public OssResult DeleteFile(string fileName)
        {
            OssResult result = new OssResult();
            return result;
        }

        /// <summary>
        /// 批量删除文件
        /// </summary>
        /// <param name="fileNameList"></param>
        /// <returns></returns>

        public OssResult DeleteFile(List<string> fileNameList)
        {
            OssResult result=new OssResult ();
            return result;
        }


        /// <summary>
        /// 拷贝文件
        /// </summary>
        /// <param name="sourceFileName">源文件</param>
        /// <param name="targetFileName">目标文件</param>
        /// <returns></returns>
        public OssResult FileCopy(string sourceFileName, string targetFileName)
        {
            OssResult result = new OssResult();
            return result;
        }

        /// <summary>
        /// 判断文件是否存在
        /// </summary>
        /// <param name="fileName"></param>
        /// <returns></returns>
        public bool FileIsExist(string fileName)
        {
            return false;
        }
    }
}