﻿
using Mall.Common;
using Mall.Model.Extend.Product;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;

namespace Mall.DataHelper
{
    /// <summary>
    /// 订单导入
    /// </summary>
    public class GoodsOrderBetchDataHelper
    {
        /// <summary>
        /// 导入模板
        /// </summary>
        /// <param name="fileName"></param>
        /// <returns></returns>
        public static List<RB_Goods_Order_Extend> ImportClaimData(string fileName)
        {
            List<RB_Goods_Order_Extend> list = new List<RB_Goods_Order_Extend>();
            var dt = new DataTable();
            if (fileName.Contains(".csv"))
            {
                dt = new CSVHelper().GetStream(fileName);
            }
            else {
                dt = Mall.Common.Plugin.NPOIHelper.ImportExceltoDt(fileName, 0, 0, true);
            }
            if (dt != null && dt.Rows.Count > 0)
            {
                foreach (DataRow dr in dt.Rows)
                {
                    list.Add(DataRowToModel(dr));
                }
            }
            return list;
        }
        /// <summary>
        /// DataRow转实体
        /// </summary>
        /// <param name="dr"></param>
        /// <returns></returns>
        public static RB_Goods_Order_Extend DataRowToModel(DataRow dr)
        {
            RB_Goods_Order_Extend model = new RB_Goods_Order_Extend();
            if (dr != null)
            {
                if (dr.Table.Columns.Contains("所属平台") && !string.IsNullOrEmpty(dr["所属平台"].ToString().Trim()))
                {
                    model.PlatformNameImport = dr["所属平台"].ToString();
                }
                if (dr.Table.Columns.Contains("订单号") && !string.IsNullOrEmpty(dr["订单号"].ToString().Trim()))
                {
                    model.OrderNo = dr["订单号"].ToString();
                }
                if (dr.Table.Columns.Contains("商户单号") && !string.IsNullOrEmpty(dr["商户单号"].ToString().Trim()))
                {
                    model.MerchantsNo = dr["商户单号"].ToString();
                }
                if (dr.Table.Columns.Contains("下单用户") && !string.IsNullOrEmpty(dr["下单用户"].ToString().Trim()))
                {
                    model.UserName = dr["下单用户"].ToString();
                }
                if (dr.Table.Columns.Contains("商品名") && !string.IsNullOrEmpty(dr["商品名"].ToString().Trim()))
                {
                    model.GoodsName = dr["商品名"].ToString();
                }
                if (dr.Table.Columns.Contains("规格") && !string.IsNullOrEmpty(dr["规格"].ToString().Trim()))
                {
                    model.SpecificationImport = dr["规格"].ToString();
                }
                if (dr.Table.Columns.Contains("数量") && !string.IsNullOrEmpty(dr["数量"].ToString().Trim()))
                {
                    model.OrderNum = Convert.ToInt32(dr["数量"].ToString());
                }
                if (dr.Table.Columns.Contains("货号") && !string.IsNullOrEmpty(dr["货号"].ToString().Trim()))
                {
                    model.ProductCode = dr["货号"].ToString();
                }
                if (dr.Table.Columns.Contains("成本价") && !string.IsNullOrEmpty(dr["成本价"].ToString().Trim()))
                {
                    model.CostMoneyImport = Convert.ToDecimal(dr["成本价"].ToString());
                }
                if (dr.Table.Columns.Contains("收件人") && !string.IsNullOrEmpty(dr["收件人"].ToString().Trim()))
                {
                    model.Consignee = dr["收件人"].ToString();
                }
                if (dr.Table.Columns.Contains("收件人电话") && !string.IsNullOrEmpty(dr["收件人电话"].ToString().Trim()))
                {
                    model.Mobile = dr["收件人电话"].ToString();
                }
                if (dr.Table.Columns.Contains("收件人地址") && !string.IsNullOrEmpty(dr["收件人地址"].ToString().Trim()))
                {
                    model.DistrictAddress = dr["收件人地址"].ToString();
                }
                if (dr.Table.Columns.Contains("总金额") && !string.IsNullOrEmpty(dr["总金额"].ToString().Trim()))
                {
                    model.PreferPrice = Convert.ToDecimal(dr["总金额"].ToString());
                }
                if (dr.Table.Columns.Contains("实际付款") && !string.IsNullOrEmpty(dr["实际付款"].ToString().Trim()))
                {
                    model.Income = Convert.ToDecimal(dr["实际付款"].ToString());
                }
                if (dr.Table.Columns.Contains("运费") && !string.IsNullOrEmpty(dr["运费"].ToString().Trim()))
                {
                    model.FreightMoney = Convert.ToDecimal(dr["运费"].ToString());
                }
                if (dr.Table.Columns.Contains("下单时间") && !string.IsNullOrEmpty(dr["下单时间"].ToString().Trim()))
                {
                    model.CreateDate = Convert.ToDateTime(dr["下单时间"].ToString());
                }
                if (dr.Table.Columns.Contains("支付方式") && !string.IsNullOrEmpty(dr["支付方式"].ToString().Trim()))
                {
                    model.PaymentWayImport = dr["支付方式"].ToString();
                }
                if (dr.Table.Columns.Contains("订单状态") && !string.IsNullOrEmpty(dr["订单状态"].ToString().Trim()))
                {
                    model.OrderStatusImport = dr["订单状态"].ToString();
                }
                if (dr.Table.Columns.Contains("付款状态") && !string.IsNullOrEmpty(dr["付款状态"].ToString().Trim()))
                {
                    model.PaymentStatusImport = dr["付款状态"].ToString();
                }
                if (dr.Table.Columns.Contains("付款时间") && !string.IsNullOrEmpty(dr["付款时间"].ToString().Trim()))
                {
                    model.PaymentTime = Convert.ToDateTime(dr["付款时间"].ToString());
                }
                if (dr.Table.Columns.Contains("发货时间") && !string.IsNullOrEmpty(dr["发货时间"].ToString().Trim()))
                {
                    model.DeliveryTime = Convert.ToDateTime(dr["发货时间"].ToString());
                }
                if (dr.Table.Columns.Contains("收货时间") && !string.IsNullOrEmpty(dr["收货时间"].ToString().Trim()))
                {
                    model.ReceivingTime = Convert.ToDateTime(dr["收货时间"].ToString());
                }
                if (dr.Table.Columns.Contains("商家备注") && !string.IsNullOrEmpty(dr["商家备注"].ToString().Trim()))
                {
                    model.Remark = dr["商家备注"].ToString();
                }
                if (dr.Table.Columns.Contains("备注/表单") && !string.IsNullOrEmpty(dr["备注/表单"].ToString().Trim()))
                {
                    model.BuyerMessage = dr["备注/表单"].ToString();
                }
                if (dr.Table.Columns.Contains("售价") && !string.IsNullOrEmpty(dr["售价"].ToString().Trim()))
                {
                    model.SellMoneyImport = Convert.ToDecimal(dr["售价"].ToString());
                }
                if (dr.Table.Columns.Contains("原价") && !string.IsNullOrEmpty(dr["原价"].ToString().Trim()))
                {
                    model.OriginalMoneyImport = Convert.ToDecimal(dr["原价"].ToString());
                }
            }
            return model;
        }
    }
}