﻿
using Mall.Model.Extend.Product;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;

namespace Mall.DataHelper
{
    public class SendGoodsBetchDataHelper
    {
        /// <summary>
        /// 导入模板
        /// </summary>
        /// <param name="fileName"></param>
        /// <returns></returns>
        public static List<RB_Goods_OrderExpress_Extend> ImportClaimData(string fileName)
        {
            List<RB_Goods_OrderExpress_Extend> list = new List<RB_Goods_OrderExpress_Extend>();
            var dt = Mall.Common.Plugin.NPOIHelper.ImportExceltoDt(fileName, 0, 0, true);
            if (dt != null && dt.Rows.Count > 0)
            {
                foreach (DataRow dr in dt.Rows)
                {
                    list.Add(DataRowToModel(dr));
                }
            }
            return list;
        }
        /// <summary>
        /// DataRow转实体
        /// </summary>
        /// <param name="dr"></param>
        /// <returns></returns>
        public static RB_Goods_OrderExpress_Extend DataRowToModel(DataRow dr)
        {
            RB_Goods_OrderExpress_Extend model = new RB_Goods_OrderExpress_Extend();
            if (dr != null)
            {
                if (dr.Table.Columns.Contains("订单号") && !string.IsNullOrEmpty(dr["订单号"].ToString().Trim()))
                {
                    model.OrderNo = dr["订单号"].ToString().Trim();
                }
                if (dr.Table.Columns.Contains("快递单号") && !string.IsNullOrEmpty(dr["快递单号"].ToString().Trim()))
                {
                    model.ExpressNumber = dr["快递单号"].ToString().Trim();
                }
            }
            return model;
        }
    }
}