﻿using Mall.Common.Enum.GuideCar;
using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Entity.GuideCar
{
    /// <summary>
    /// 司导-车辆实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_GuideCar_Car
    {
        public int ID { get; set; }

        /// <summary>
        /// 商户id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }



        /// <summary>
        /// 车辆名称
        /// </summary>
        public string Name { get; set; }


        public int Status { get; set; }

        public DateTime CreateDate { get; set; }
        public DateTime UpdateDate { get; set; }


        /// <summary>
        /// 头像
        /// </summary>
        public string CarLogo { get; set; }


        /// <summary>
        /// 车辆型号
        /// </summary>
        public string CarType { get; set; }

        /// <summary>
        /// 车辆分类
        /// </summary>
        public CarClassEnum CarClass { get; set; }
       
        /// <summary>
        /// 车辆品牌
        /// </summary>
        public int CarBrandId { get; set; }
        /// <summary>
        /// 可乘坐人数
        /// </summary>
        public int GuestNum { get; set; }

        /// <summary>
        /// 用户评分
        /// </summary>
        public decimal Score { get; set; }


    }
}
