﻿using VT.FW.DB;
using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Entity.BaseSetUp;
using Mall.Model.Extend.BaseSetUp;
using Mall.Common.Enum.GuideCar;

namespace Mall.Model.Extend.Product
{
    /// <summary>
    /// 商品表扩展实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Goods_Extend : RB_Goods
    {
        /// <summary>
        /// 课程是否已付款
        /// </summary>
        public bool IsPay { get; set; }
        /// <summary>
        /// 课程列表
        /// </summary>
        public List<RB_Goods_WK_Course_Extend> CourseList { get; set; }
        /// <summary>
        /// 教师列表
        /// </summary>
        public List<RB_Goods_WK_Teacher_Extend> TeacherList { get; set; }
        /// <summary>
        /// 可预定日期
        /// </summary>
        public List<RB_Goods_TargetDate_Extend> TargetDateList { get; set; }
        /// <summary>
        /// 日期
        /// </summary>
        public List<string> TargetDateStrList { get; set; }
        /// <summary>
        /// 线路描述list
        /// </summary>
        public List<string> LineDescriptionList { get; set; }
        /// <summary>
        /// 课程标签
        /// </summary>
        public List<string> CourseLableList { get; set; }

        /// <summary>
        /// 课程章节数
        /// </summary>
        public int CourseNum { get; set; }
        /// <summary>
        /// 教师id
        /// </summary>
        public int TeacherId { get; set; }
        

        #region 司导信息
        /// <summary>
        /// 站点名称
        /// </summary>
        public string SiteName { get; set; }
        /// <summary>
        /// 导游名称
        /// </summary>
        public string GuideName { get; set; }

        /// <summary>
        /// 从业年限
        /// </summary>
        public decimal GuideWorkYears { get; set; }

        /// <summary>
        /// 用户评分
        /// </summary>
        public decimal GuideScore { get; set; }

        /// <summary>
        /// 联系电话
        /// </summary>
        public string GuideTelephone { get; set; }
        /// <summary>
        /// 导游简介
        /// </summary>
        public string Introduction { get; set; }

        /// <summary>
        /// 头像
        /// </summary>
        public string GuidePhoto { get; set; }

        /// <summary>
        /// 车辆名称
        /// </summary>
        public string CarName { get; set; }
        /// <summary>
        /// 车辆颜色
        /// </summary>
        public string CarColorName { get; set; }

        /// <summary>
        /// 车辆评分
        /// </summary>
        public decimal CarScore { get; set; }
        /// <summary>
        /// 车型号
        /// </summary>
        public string CarModel { get; set; }
        /// <summary>
        /// 车辆类型
        /// </summary>
        public int? CarClass { get; set; }

        public string RegionIds { get; set; }

        /// <summary>
        /// 车辆品牌
        /// </summary>
        public int? CarBrandId { get; set; }

        /// <summary>
        /// 剩余座位数
        /// </summary>
        public int SurplusNum { get; set; }

        /// <summary>
        /// 地区
        /// </summary>
        public int RegionId { get; set; }


        /// <summary>
        /// 车辆型号
        /// </summary>
        public string GuideCarType { get; set; }
        #endregion

        /// <summary>
        /// 教师名称
        /// </summary>
        public string TeacherName { get; set; }
        /// <summary>
        /// 微店id
        /// </summary>
        public int? SmallShopsId { get; set; }
        /// <summary>
        /// 推荐商品类型  1商品详情页  2订单完成后   3评论后
        /// </summary>
        public int? RecommendType { get; set; }
        /// <summary>
        /// 商品id
        /// </summary>
        public int? GoodsId { get; set; }
        /// <summary>
        /// 排除商品id
        /// </summary>
        public int? NoGoodsId { get; set; }
        /// <summary>
        /// 采购商品id
        /// </summary>
        public int? ProcurementGoodsId { get; set; }
        /// <summary>
        /// 其他商户
        /// </summary>
        public int? NotTenantId { get; set; }
        /// <summary>
        /// 商品购买的数量
        /// </summary>
        public int? GoodsBuyNum { get; set; }
        /// <summary>
        /// 视频播放方向  1向下  2向上
        /// </summary>
        public int? SelectVideoDirection { get; set; }
        /// <summary>
        /// 小程序名称
        /// </summary>
        public string MallName { get; set; }
        /// <summary>
        /// 用户id
        /// </summary>
        public int? UserId { get; set; }
        /// <summary>
        /// 值查询有视频的
        /// </summary>
        public int? IsSelectVideo { get; set; }
        /// <summary>
        /// 排序
        /// </summary>
        public int? OrderBy { get; set; }
        /// <summary>
        /// 开始时间
        /// </summary>
        public string StartTime { get; set; }
        /// <summary>
        /// 结束时间
        /// </summary>
        public string EndTime { get; set; }
        /// <summary>
        /// 是否查询售罄   1是  其他否
        /// </summary>
        public int? IsSelectSellOut { get; set; }
        /// <summary>
        /// 分类ids
        /// </summary>
        public string CategoryIds { get; set; }

        /// <summary>
        /// 商品分类Id【HK0803新增】
        /// </summary>
        public int CategoryId { get; set; }

        /// <summary>
        /// 商品ids
        /// </summary>
        public string GoodsIds { get; set; }
        /// <summary>
        /// 商品str
        /// </summary>
        public string GoodsNameStr { get; set; }
        /// <summary>
        /// 封面图
        /// </summary>
        public string CoverImage { get; set; }


        /// <summary>
        /// 自定义分享图片
        /// </summary>
        public string CustomShareImagePath { get; set; }
        /// <summary>
        /// 运费名称
        /// </summary>
        public string FreightName { get; set; }
        /// <summary>
        /// 表单名称
        /// </summary>
        public string FormsName { get; set; }
        /// <summary>
        /// 轮播图列表
        /// </summary>
        public List<RB_ImageCommonModel> CarouselImageList { get; set; }
        /// <summary>
        /// 服务列表
        /// </summary>
        public List<RB_ImageCommonModel> ServiceList { get; set; }
        /// <summary>
        /// 商品分类
        /// </summary>
        public List<RB_Goods_Category_Extend> CategoryList { get; set; }


        /// <summary>
        /// 区域列表
        /// </summary>
        public List<RB_Goods_Area_Extend> AreaList { get; set; }
        /// <summary>
        /// 区域购买导入
        /// </summary>
        public string AreaImport { get; set; }
        /// <summary>
        /// 规格名列表
        /// </summary>
        public List<RB_Goods_Specification_Extend> SpecificationList { get; set; }
        /// <summary>
        /// 规格组导入
        /// </summary>
        public string SpecificationImport { get; set; }
        /// <summary>
        /// 规格值名称列表
        /// </summary>
        public List<string> SpecificationNameList { get; set; }
        /// <summary>
        /// 规格价格列表
        /// </summary>
        public List<RB_Goods_SpecificationPrice_Extend> SpecificationPriceList { get; set; }
        /// <summary>
        /// 规格价格详情导入
        /// </summary>
        public string SpecificationPriceImport { get; set; }
        /// <summary>
        /// 分销佣金列表
        /// </summary>
        public List<RB_Goods_DistributionCommission_Extend> DistributionCommissionList { get; set; }

        /// <summary>
        /// 分销佣金列表(2号)
        /// </summary>
        public List<RB_Goods_DistributionCommission_Extend> DistributionCommissionTreeList { get; set; }

        /// <summary>
        /// 会员价格列表
        /// </summary>
        public List<RB_Goods_MemberPrice_Extend> MemberPriceList { get; set; }
        /// <summary>
        /// 会员价格列表
        /// </summary>
        public List<RB_Goods_MemberPrice_Extend> MemberPriceTreeList { get; set; }

        /// <summary>
        /// 是否收藏  true/false
        /// </summary>
        public bool Favorite { get; set; }
        /// <summary>
        /// 快递费用
        /// </summary>
        public decimal Express { get; set; }
        /// <summary>
        /// 最高分销返佣
        /// </summary>
        public decimal MaxShare { get; set; }

        /// <summary>
        /// 会员价格
        /// </summary>
        public decimal MemberPrice { get; set; }

        /// <summary>
        /// 供应商ids  2020-08-04 Add By:W
        /// </summary>
        public string SupplierIds { get; set; }

        /// <summary>
        /// 商品分类包邮规则
        /// </summary>
        public RB_FreeShipping_Extend FreeShippingModel { get; set; }

        /// <summary>
        /// 供应商-我的产品
        /// </summary>
        public List<object> SupplierSpecificationList { get; set; }

        /// <summary>
        /// 是否直查询有视频商品(1-是)HK0902新增
        /// </summary>
        public int IsVideo { get; set; }

        /// <summary>
        /// ERP商品对象
        /// </summary>
        public object ERPGoodObj { get; set; }

        /// <summary>
        /// 门店列表
        /// </summary>
        public List<int> StoresList
        {
            get
            {
                return Common.ConvertHelper.ConvertToListInt(this.StoresIds);
            }
        }

        /// <summary>
        /// 门店名称
        /// </summary>
        public List<string> StoreNameList { get; set; }
    }
}
