﻿using VT.FW.DB;
using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;

namespace Mall.Model.Extend.Product
{
    /// <summary>
    /// 商品订单售后表扩展实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Goods_OrderAfterSale_Extend : RB_Goods_OrderAfterSale
    {
        /// <summary>
        /// 订单明细ids
        /// </summary>
        public string OrderDetailIds { get; set; }
        /// <summary>
        /// 订单号
        /// </summary>
        public string OrderNo { get; set; }
        /// <summary>
        /// 用户名
        /// </summary>
        public string UserName { get; set; }
        /// <summary>
        /// 商品名称
        /// </summary>
        public string GoodsName { get; set; }
        /// <summary>
        /// 收件人
        /// </summary>
        public string Consignee { get; set; }
        /// <summary>
        /// 收件人电话
        /// </summary>
        public string Mobile { get; set; }
        /// <summary>
        /// 用户平台
        /// </summary>
        public int OrderSource { get; set; }
        /// <summary>
        /// 开始时间
        /// </summary>
        public string StartTime { get; set; }
        /// <summary>
        /// 结束时间
        /// </summary>
        public string EndTime { get; set; }
        /// <summary>
        /// 订单
        /// </summary>
        public RB_Goods_Order_Extend OrderModel { get; set; }
        /// <summary>
        /// 订单明细
        /// </summary>
        public RB_Goods_OrderDetail_Extend OrderDetailModel { get; set; }

        /// <summary>
        /// 导出选项
        /// </summary>
        public List<int> ExcelEnumIds { get; set; }
        /// <summary>
        /// 客人退货物流名称
        /// </summary>
        public string ReExpressName { get; set; }
        /// <summary>
        /// 查询状态
        /// </summary>
        public int SelectStatus { get; set; }
        /// <summary>
        /// 凭证列表
        /// </summary>
        public List<string> VoucherList { get; set; }

        /// <summary>
        /// 完成开始时间
        /// </summary>
        public string FStartTime { get; set; }
        /// <summary>
        /// 完成结束时间
        /// </summary>
        public string FEndTime { get; set; }
    }
}
