﻿using Mall.Model.Entity.GuideCar;
using Mall.Model.Extend.GuideCar;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.GuideCar
{
    /// <summary>
    /// 车辆颜色仓储层
    /// </summary>
    public class RB_GuideCar_CarColorRepository : BaseRepository<RB_GuideCar_CarColor>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_GuideCar_CarColor); } }
        /// <summary>
        /// 车辆颜色列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_GuideCar_CarColor_Extend> GetCarColorPageListRepository(int pageIndex, int pageSize, out long rowCount, RB_GuideCar_CarColor_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE  {nameof(RB_GuideCar_CarColor_Extend.Status)}=0");
            if (query != null)
            {
                // where += $@" and {nameof(RB_Customer_InfoCreate.CustomerId)}={dmodel.CustomerId}";
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_GuideCar_CarColor_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_GuideCar_CarColor_Extend.MallBaseId)}={query.MallBaseId}");
                }

                if (query.CarId > 0)
                {
                    builder.Append($" AND {nameof(RB_GuideCar_CarColor_Extend.CarId)}={query.CarId}");
                }
            }
            return GetPage<RB_GuideCar_CarColor_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }


        /// <summary>
        /// 车辆颜色列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_GuideCar_CarColor_Extend> GetCarColorList(RB_GuideCar_CarColor_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE {nameof(RB_GuideCar_CarColor_Extend.Status)}=0 ");
            if (query != null)
            {
                if (query.ID > 0)
                {
                    builder.Append($" AND {nameof(RB_GuideCar_CarColor_Extend.ID)}={query.ID}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_GuideCar_CarColor_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_GuideCar_CarColor_Extend.MallBaseId)}={query.MallBaseId}");
                }

                if (query.CarId > 0)
                {
                    builder.Append($" AND {nameof(RB_GuideCar_CarColor_Extend.CarId)}={query.CarId}");
                }
                if (!string.IsNullOrWhiteSpace(query.CardIds))
                {
                    builder.Append($" AND {nameof(RB_GuideCar_CarColor_Extend.CarId)} in ({query.CardIds})");
                }
            }
            return Get<RB_GuideCar_CarColor_Extend>(builder.ToString()).ToList();
        }
    }
}
