﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 商品可预定日期仓储层
    /// </summary>
    public class RB_Goods_TargetDateRepository : BaseRepository<RB_Goods_TargetDate>
    {

        /// <summary>
        /// 列表
        /// </summary>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Goods_TargetDate_Extend> GetList(RB_Goods_TargetDate_Extend dmodel)
        {
            string where = $" 1=1 and Date >= '{DateTime.Now.ToString("yyyy-MM-dd")}'";
            
            if (dmodel.Id > 0) {
                where += $@" and {nameof(RB_Goods_TargetDate.Id)}={dmodel.Id}";
            }
            if (dmodel.GoodsId > 0) {
                where += $@" and {nameof(RB_Goods_TargetDate.GoodsId)}={dmodel.GoodsId}";
            }
            if (!string.IsNullOrEmpty(dmodel.GoodsIds)) {
                where += $@" and {nameof(RB_Goods_TargetDate.GoodsId)} in({dmodel.GoodsIds})";
            }
            if (!string.IsNullOrEmpty(dmodel.DateTime)) {
                where += $@" and {nameof(RB_Goods_TargetDate.Date)} ='{dmodel.DateTime}'";
            }
            if (!string.IsNullOrEmpty(dmodel.StartTime)) {
                where += $@" and {nameof(RB_Goods_TargetDate.Date)} >='{dmodel.StartTime}'";
            }
            if (!string.IsNullOrEmpty(dmodel.EndTime)) {
                where += $@" and {nameof(RB_Goods_TargetDate.Date)} <='{dmodel.EndTime} 23:59:59'";
            }
            if (!string.IsNullOrEmpty(dmodel.Month))
            {
                where += $@" and DATE_FORMAT(Date,'%Y-%m') ='{dmodel.Month}'";
            }
            if (dmodel.IsReserve > 0) {
                where += $@" and {nameof(RB_Goods_TargetDate.IsReserve)}={dmodel.IsReserve}";
            }
            
            string sql = $@"select * from RB_Goods_TargetDate where {where} order by Date asc";
            return Get<RB_Goods_TargetDate_Extend>(sql).ToList();
        }
    }
}
