﻿using Mall.Model.Entity.Property;
using Mall.Model.Extend.Property;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.Property
{
    /// <summary>
    /// 集团扩展方法
    /// </summary>
    public partial class Rb_Group_Repository : BaseRepository<RB_Group>
    {
        /// <summary>
        /// 获取分页数据
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="dmodel"></param>
        /// <param name="count"></param>
        /// <returns></returns>
        public List<RB_Group_Extend> GetPageList(int pageIndex, int pageSize, RB_Group_Extend dmodel, out long count)
        {
            string where = " WHERE 1=1 ";
            if (!string.IsNullOrWhiteSpace(dmodel.GroupName))
            {
                where += " AND g." + nameof(RB_Group.GroupName) + " like '%" + dmodel.GroupName + "%'";
            }
            if (!string.IsNullOrWhiteSpace(dmodel.Domain))
            {
                where += " AND g." + nameof(RB_Group.Domain) + " like '%" + dmodel.Domain + "%'";
            }
            if (dmodel.Status.HasValue && dmodel.Status >= 0)
            {
                where += " AND g." + nameof(RB_Group.Status) + "=" + (int)dmodel.Status;
            }
            //where += string.Format(" ORDER BY g.{0} DESC ", nameof(Model.Entity.RB_Group.Id));
            var pageList = GetPage<RB_Group_Extend>(pageIndex, pageSize, out count, "select g.*,v.VersionsName,e.EmAccount from Rb_group g left join rb_employee e on g.AdminAccount=e.EmployeeId Left join Rb_sys_versions v on g.Versions_Id=v.Id " + where + " order by g.Id desc").ToList();
            return pageList;
        }

        /// <summary>
        /// 根据where获取list
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Group_Extend> GetList(RB_Group_Extend dmodel)
        {
            string where = " WHERE 1=1";
            if (dmodel.Id > 0)
            {
                where += " AND " + nameof(RB_Group_Extend.Id) + "=" + dmodel.Id;
            }
            if (dmodel.Status.HasValue)
            {
                where += " AND " + nameof(RB_Group_Extend.Status) + "=" + (int)dmodel.Status;
            }
            if (!string.IsNullOrWhiteSpace(dmodel.GroupName))
            {
                where += " AND " + nameof(RB_Group_Extend.GroupName) + " like '%" + dmodel.Status + "%'";
            }

            if (dmodel.IsEquit == 1)
            {
                if (!string.IsNullOrWhiteSpace(dmodel.Domain))
                {
                    where += " AND " + nameof(RB_Group_Extend.Domain) + " = '" + dmodel.Domain + "'";
                }
                if (!string.IsNullOrWhiteSpace(dmodel.B2BDomain))
                {
                    where += " AND " + nameof(RB_Group_Extend.B2BDomain) + " = '" + dmodel.B2BDomain + "'";
                }
            }
            else
            {
                if (!string.IsNullOrWhiteSpace(dmodel.Domain))
                {
                    where += " AND " + nameof(RB_Group_Extend.Domain) + " like '%" + dmodel.Domain + "%'";
                }
                if (!string.IsNullOrWhiteSpace(dmodel.B2BDomain))
                {
                    where += " AND " + nameof(RB_Group_Extend.B2BDomain) + " like '%" + dmodel.B2BDomain + "%'";
                }
            }
            if (dmodel.Versions_Id.HasValue)
            {
                where += " AND " + nameof(RB_Group_Extend.Versions_Id) + "=" + dmodel.Versions_Id;
            }

            where += string.Format(" ORDER BY {0} DESC ", nameof(RB_Group.Id));
            return Get<RB_Group_Extend>("select * from RB_Group " + where).ToList();
        }


        /// <summary>
        /// 根据where获取list
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Group_Extend> GetListByDomain(RB_Group_Extend dmodel)
        {
            string where = " WHERE 1=1";
            if (dmodel.Status.HasValue)
            {
                where += " AND " + nameof(RB_Group_Extend.Status) + "=" + (int)dmodel.Status;
            }
            if (!string.IsNullOrWhiteSpace(dmodel.GroupName))
            {
                where += " AND " + nameof(RB_Group_Extend.GroupName) + " like '%" + dmodel.Status + "%'";
            }
            if (!string.IsNullOrWhiteSpace(dmodel.Domain))
            {
                where += " AND " + nameof(RB_Group_Extend.Domain) + " ='" + dmodel.Domain + "'";
            }
            if (!string.IsNullOrWhiteSpace(dmodel.B2BDomain))
            {
                where += " AND " + nameof(RB_Group_Extend.B2BDomain) + " ='" + dmodel.B2BDomain + "'";
            }
            if (dmodel.Versions_Id.HasValue)
            {
                where += " AND " + nameof(RB_Group_Extend.Versions_Id) + "=" + dmodel.Versions_Id;
            }
            where += string.Format(" ORDER BY {0} DESC ", nameof(RB_Group.Id));
            return Get<RB_Group_Extend>("select * from RB_Group " + where).ToList();
        }
    }
}
