﻿using Aliyun.OSS;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using Mall.ThirdCore.Commom;
using System;
using System.Collections.Generic;
using System.IO;
using Mall.Common.Plugin;

namespace Mall.ThirdCore.Oss
{
    /// <summary>
    /// 阿里云存储服务
    /// 文件路径名前不能以/开头
    /// </summary>
    public class OytourOssService : IOssService
    {

        /// <summary>
        /// 获取是实例
        /// </summary>
        /// <returns></returns>
        public static OytourOssService Instance()
        {
            return new OytourOssService();
        }

        /// <summary>
        /// 上传文件
        /// </summary>
        /// <param name="fileName">文件名</param>
        /// <param name="stream">文件流</param>
        /// <returns></returns>
        public OssResult UploadFile(string fileName, System.IO.Stream stream)
        {
            OssResult ossResult = new OssResult();
            try
            {
                string filePath = fileName.Substring(0, fileName.LastIndexOf('\\'));
                if (!Directory.Exists(filePath))
                {
                    Directory.CreateDirectory(filePath);
                }
                ossResult.resultCode = 1;
                var bytes = StreamToBytes(stream);
                FileStream fs = new FileStream(fileName, FileMode.Create, FileAccess.Write);
                fs.Write(bytes, 0, bytes.Length);
                fs.Flush();
                fs.Close();
            }
            catch (Exception ex)
            {
                ossResult.resultCode = 0;
                Mall.Common.Plugin.LogHelper.Write(ex,"OytourOssService_UploadFile文件上传保存失败");
            }
            return ossResult;
        }

        /// <summary>
        /// 文件流转字节数组
        /// </summary>
        /// <param name="stream"></param>
        /// <returns></returns>
        public byte[] StreamToBytes(Stream stream)
        {
            byte[] bytes = new byte[stream.Length];
            stream.Read(bytes, 0, bytes.Length);
            // 设置当前流的位置为流的开始 
            stream.Seek(0, SeekOrigin.Begin);
            return bytes;
        }

        /// <summary>
        /// 删除文件
        /// </summary>
        /// <param name="fileName"></param>
        /// <returns></returns>
        public OssResult DeleteFile(string fileName)
        {
            OssResult ossResult = new OssResult();
            try
            {
                Common.Plugin.FileHelper.DeleteFileExt(fileName);
                ossResult.resultCode = 1;
                return ossResult;
            }
            catch (Exception e)
            {
                Mall.Common.Plugin.LogHelper.Write(e, "OytourOssService_DeleteFile" + e.ToString());
                ossResult.resultCode = 0;
                ossResult.message = e.ToString();
                return ossResult;
            }
        }


        /// <summary>
        /// 批量删除文件
        /// </summary>
        /// <param name="fileNameList"></param>
        /// <returns></returns>
        public OssResult DeleteFile(List<string> fileNameList)
        {
            OssResult ossResult = new OssResult();
            try
            {
                Common.Plugin.FileHelper.DeleteFileList(fileNameList);
                ossResult.resultCode = 1;
                return ossResult;
            }
            catch (Exception e)
            {
                Mall.Common.Plugin.LogHelper.Write(e, "OytourOssService_DeleteFileList" + e.ToString());
                ossResult.resultCode = 0;
                ossResult.message = e.ToString();
                return ossResult;
            }
        }

        /// <summary>
        /// 文件拷贝
        /// </summary>
        /// <param name="sourceFileName"></param>
        /// <param name="targetFileName"></param>
        /// <returns></returns>
        public OssResult FileCopy(string sourceFileName, string targetFileName)
        {
            OssResult ossResult = new OssResult();
            try
            {
                Common.Plugin.FileHelper.FileCopy(sourceFileName, targetFileName);
                ossResult.resultCode = 1;
                return ossResult;
            }
            catch (Exception e)
            {
                Mall.Common.Plugin.LogHelper.Write(e, "OytourOssService_FileCopy" + e.ToString());
                ossResult.resultCode = 0;
                ossResult.message = e.ToString();
                return ossResult;
            }
        }

        /// <summary>
        /// 判断文件是否存在
        /// </summary>
        /// <param name="fileName"></param>
        /// <returns></returns>
        public bool FileIsExist(string fileName)
        {
            return Common.Plugin.FileHelper.FileExists(fileName);
        }
    }
}
