﻿using System.Linq;
using Mall.Common.API;
using Microsoft.AspNetCore.Mvc;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Mall.Module.MarketingCenter;
using Newtonsoft.Json;
using Mall.Model.Query;
using System;
using Mall.Common.Plugin;
using System.Collections.Generic;
using Mall.Model.Extend.MarketingCenter;
using Newtonsoft.Json.Linq;
using Mall.Model.Entity.MarketingCenter;
using Mall.CacheManager.User;

namespace Mall.WebApi.Controllers.MarketingCenter
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class TemplateController : BaseController
    {
        /// <summary>
        /// 模板处理类
        /// </summary>
        private readonly Module.MarketingCenter.MiniprogramTemplateModule templateModule = new MiniprogramTemplateModule();

        /// <summary>
        /// 自定义页面处理类
        /// </summary>
        private readonly MiniprogramPageTemplModule miniprogramPageTemplModule = new MiniprogramPageTemplModule();

        /// <summary>
        /// 模板市场处理类
        /// </summary>
        private readonly TemplateMarketModule templateMarketModule = new TemplateMarketModule();

        #region 模板管理
        /// <summary>
        /// 新增修改小程序模板
        /// </summary>
        /// <returns></returns>
        public ApiResult SetMiniTemplate()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Miniprogram_Template_Extend>(RequestParm.msg.ToString());
            extModel.TenantId = RequestParm.TenantId;
            extModel.MallBaseId = RequestParm.MallBaseId;
            if (extModel.ComponentDataList != null && extModel.ComponentDataList.Count > 0)
            {
                extModel.TemplateData = JsonConvert.SerializeObject(extModel.ComponentDataList);
            }
            Int32.TryParse(RequestParm.uid, out int Uid);
            extModel.CreateBy = Uid;
            extModel.CreateDate = DateTime.Now;
            extModel.Status = 0;
            var flag = templateModule.SetMiniprogramTemplateModule(extModel);
            return flag ? ApiResult.Success(data: extModel.Id) : ApiResult.Failed();
        }

        /// <summary>
        /// 获取小程序模板实体
        /// </summary>
        /// <returns></returns>
        public ApiResult GetMiniTemplate()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id");
            var extModel = templateModule.GetMiniprogramTemplateModule(Id);
            if (extModel != null && extModel.Id > 0)
            {
                var obj = new
                {
                    extModel.Id,
                    extModel.TemplateName,
                    extModel.ComponentDataList,
                };
                return ApiResult.Success(data: obj);
            }
            return ApiResult.Failed(message: "参数错误");
        }

        /// <summary>
        /// 删除小程序模板
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveMiniTemplate()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var Status = parms.GetInt("Status", 1);
            var flag = templateModule.RemoveMiniprogramTemplateModule(Id, Status);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 小程序模板分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetMiniTemplatePageList()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(parms.msg.ToString());
            var query = JsonConvert.DeserializeObject<RB_Miniprogram_Template_Extend>(parms.msg.ToString());
            query.TenantId = Convert.ToInt32(parms.uid);
            query.MallBaseId = parms.MallBaseId;

            var list = templateModule.GetMiniprogramTemplatePageListModule(pagelist.pageIndex, pagelist.pageSize, out long count, query);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list;
            return ApiResult.Success("", pagelist);
        }
        #endregion

        #region 自定义页面管理

        /// <summary>
        /// 小程序自定义页面分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetMiniprogramPageTemplPageList()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(parms.msg.ToString());
            var query = JsonConvert.DeserializeObject<RB_Miniprogram_Page_Templ_Extend>(parms.msg.ToString());
            query.TenantId = Convert.ToInt32(parms.uid);
            query.MallBaseId = parms.MallBaseId;

            var list = miniprogramPageTemplModule.GetMiniprogramPageTemplPageListModule(pagelist.pageIndex, pagelist.pageSize, out long count, query);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list;
            return ApiResult.Success("", pagelist);
        }

        /// <summary>
        /// 小程序自定义页面列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetMiniprogramPageTemplList()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_Miniprogram_Page_Templ_Extend>(parms.msg.ToString());
            query.TenantId = Convert.ToInt32(parms.uid);
            query.MallBaseId = parms.MallBaseId;
            var list = miniprogramPageTemplModule.GetMiniprogramPageTemplListModule(query);
            return ApiResult.Success("", list);
        }

        /// <summary>
        /// 小程序自定义页面实体
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetMiniprogramPageTempl()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = JsonConvert.DeserializeObject<RB_Miniprogram_Page_Templ_Extend>(RequestParm.msg.ToString());
            query.TenantId = Convert.ToInt32(RequestParm.uid);
            query.MallBaseId = RequestParm.MallBaseId;
            bool isGetHome = parms.GetBoolValue("isGetHome");
            var extModel = miniprogramPageTemplModule.GetMiniprogramPageTemplModule(query, isGetHome: isGetHome);
            return ApiResult.Success("", extModel);
        }

        /// <summary>
        /// 新增修改自定义页面
        /// </summary>
        /// <returns></returns>
        public ApiResult SetMiniprogramPageTempl()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Miniprogram_Page_Templ_Extend>(RequestParm.msg.ToString());
            extModel.TenantId = RequestParm.TenantId;
            extModel.MallBaseId = RequestParm.MallBaseId;

            Int32.TryParse(RequestParm.uid, out int Uid);
            extModel.CreateBy = Uid;
            extModel.CreateDate = DateTime.Now;
            extModel.Status = 0;
            var flag = miniprogramPageTemplModule.SetMiniprogramPageTemplModule(extModel);
            return flag ? ApiResult.Success(data: extModel.Id) : ApiResult.Failed();
        }

        /// <summary>
        /// 更新自定义页面状态
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveMiniprogramPageTempl()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var Status = parms.GetInt("Status", 1);
            var flag = miniprogramPageTemplModule.RemoveMiniprogramPageTemplModule(Id, Status);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 更新模板禁用、启用
        /// </summary>
        /// <returns></returns>
        public ApiResult SetMiniprogramPageTemplIsUse()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var IsUse = parms.GetInt("IsUse", 0);
            var flag = miniprogramPageTemplModule.SetMiniprogramPageTemplIsUseModule(Id, IsUse);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 更新模板是否设为首页
        /// </summary>
        /// <returns></returns>
        public ApiResult SetMiniprogramPageTemplIsHome()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var IsHome = parms.GetInt("IsHome", 1);
            var flag = miniprogramPageTemplModule.SetMiniprogramPageTemplIsHomeModule(Id, IsHome);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }


        /// <summary>
        /// 更新自定义页面状态
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveMiniprogramPageTemplDetails()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var flag = miniprogramPageTemplModule.RemoveMiniprogramPageTemplDetailsModule(Id);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion

        #region 模板市场

        /// <summary>
        /// 模板市场分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetTemplateMarketPageListModule()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(parms.msg.ToString());
            var query = JsonConvert.DeserializeObject<RB_Template_Market_Extend>(parms.msg.ToString());
            var list = templateMarketModule.GetTemplateMarketPageListModule(pagelist.pageIndex, pagelist.pageSize, out long count, query);
            if (list != null && list.Count > 0)
            {
                foreach (var item in list)
                {
                    if (item.CreateBy > 0)
                    {
                        item.CreateByName = UserReidsCache.GetUserLoginInfo(item.CreateBy)?.Account ?? "";
                    }
                }
            }
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list;
            return ApiResult.Success("", pagelist);
        }

        /// <summary>
        /// 模板市场列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetTemplateMarketList()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_Template_Market_Extend>(parms.msg.ToString());
            var list = templateMarketModule.GetTemplateMarketListModule(query);
            return ApiResult.Success("", list);
        }

        /// <summary>
        /// 根据编号获取模板市场实体
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetTemplateMarket()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = templateMarketModule.GetTemplateMarketModule(Id);
            return ApiResult.Success("", extModel);
        }

        /// <summary>
        /// 添加修改模板市场
        /// </summary>
        /// <returns></returns>
        public ApiResult SetTemplateMarket()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Template_Market_Extend>(RequestParm.msg.ToString());
            Int32.TryParse(RequestParm.uid, out int Uid);
            extModel.CreateBy = Uid;
            extModel.CreateDate = DateTime.Now;
            extModel.Status = 0;
            var flag = templateMarketModule.SetTemplateMarketModule(extModel);
            return flag ? ApiResult.Success(data: extModel.Id) : ApiResult.Failed();
        }

        /// <summary>
        /// 删除模板市场
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveTemplateMarket()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var flag = templateMarketModule.RemoveTemplateMarketModule(Id);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 更新模板市场是否显示
        /// </summary>
        /// <returns></returns>
        public ApiResult UpdateTemplateMarketIsShow()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var IsShow = parms.GetInt("IsShow", 0);
            var flag = templateMarketModule.UpdateTemplateMarketIsShowModule(Id, IsShow);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 更新模板市场是否显示
        /// </summary>
        /// <returns></returns>
        public ApiResult UpdateTemplateMarketIsUse()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var IsUse = parms.GetInt("IsUse", 0);
            var flag = templateMarketModule.UpdateTemplateMarketIsUseModule(Id, IsUse);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 加载模板
        /// </summary>
        /// <returns></returns>
        public ApiResult LoadTemplateMarket()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            Int32.TryParse(RequestParm.uid, out int Uid);
            var extModel = new RB_Miniprogram_Template_Extend()
            {
                Id = 0,
                ComponentDataList = new List<ComponentItem>(),
                CreateBy = Uid,
                TenantId = RequestParm.TenantId,
                MallBaseId = RequestParm.MallBaseId,
                CreateDate = DateTime.Now,
                Status = 0
            };
            var flag = templateMarketModule.LoadTemplateMarketIsUseModule(Id, extModel);
            return flag ? ApiResult.Success(data: extModel) : ApiResult.Failed();
        }
        #endregion
    }
}