﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.Model.Extend.User;
using Mall.Module.User;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Mall.Common.Plugin;
using Mall.Common.Enum.User;
using Mall.CacheManager.User;
using Newtonsoft.Json.Linq;
using Mall.Common;
using Mall.Model.Extend.Product;

namespace Mall.WebApi.Controllers.User
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class AppletUserController : BaseController
    {

        private readonly UserModule userModule = new UserModule();

        #region 收货地址

        /// <summary>
        /// 获取收货地址分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetUserShippingAddressPageList() {
            var req = RequestParm;
            var userInfo = AppletUserInfo;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(req.msg.ToString());
            RB_Member_ShippingAddress_Extend demodel = JsonConvert.DeserializeObject<RB_Member_ShippingAddress_Extend>(req.msg.ToString());

            demodel.UserId = userInfo.UserId;
            demodel.TenantId = userInfo.TenantId;
            demodel.MallBaseId = userInfo.MallBaseId;
            var list = userModule.GetUserShippingAddressPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.Id,
                x.Name,
                x.Mobile,
                x.Country,
                x.Province,
                x.City,
                x.District,
                x.DistrictAddress,
                x.Address,
                x.PostCode,
                x.Lonlat,
                x.IsDefault,
                UpdateDate = x.UpdateDate.HasValue ? x.UpdateDate.Value.ToString("yyyy-MM-dd HH:mm:ss") : ""
            });

            return ApiResult.Success("", pagelist);
        }

        /// <summary>
        /// 获取收货地址列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetUserShippingAddressList()
        {
            var req = RequestParm;
            var userInfo = AppletUserInfo;
            RB_Member_ShippingAddress_Extend demodel = JsonConvert.DeserializeObject<RB_Member_ShippingAddress_Extend>(req.msg.ToString());

            demodel.UserId = userInfo.UserId;
            demodel.TenantId = userInfo.TenantId;
            demodel.MallBaseId = userInfo.MallBaseId;
            var list = userModule.GetUserShippingAddressList(demodel);
            return ApiResult.Success("", list.Select(x => new
            {
                x.Id,
                x.Name,
                x.Mobile,
                x.Country,
                x.Province,
                x.City,
                x.District,
                x.DistrictAddress,
                x.Address,
                x.PostCode,
                x.Lonlat,
                x.IsDefault,
                UpdateDate = x.UpdateDate.HasValue ? x.UpdateDate.Value.ToString("yyyy-MM-dd HH:mm:ss") : ""
            }));
        }

        /// <summary>
        /// 获取收货地址详情
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetUserShippingAddressInfo() {
            var req = RequestParm;
            var userInfo = AppletUserInfo;
            JObject parms = JObject.Parse(req.msg.ToString());
            int AddressId = parms.GetInt("AddressId", 0);
            if (AddressId <= 0) {
                return ApiResult.ParamIsNull("请传递收货地址");
            }
            var model = userModule.GetUserShippingAddressInfo(AddressId);
            if (model.TenantId != userInfo.TenantId || model.MallBaseId != userInfo.MallBaseId || model.UserId != userInfo.UserId)
            {
                return ApiResult.ParamIsNull("未查询到相关信息");
            }
            return ApiResult.Success("", new
            {
                model.Id,
                model.Name,
                model.Mobile,
                model.Country,
                model.Province,
                model.City,
                model.District,
                model.DistrictAddress,
                model.Address,
                model.PostCode,
                model.Lonlat,
                model.IsDefault
            });
        }

        /// <summary>
        /// 新增修改地址
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetUserShippingAddress() {
            var req = RequestParm;
            var userInfo = AppletUserInfo;
            RB_Member_ShippingAddress_Extend demodel = JsonConvert.DeserializeObject<RB_Member_ShippingAddress_Extend>(req.msg.ToString());
            if (string.IsNullOrEmpty(demodel.Name)) {
                return ApiResult.ParamIsNull("请输入收货人");
            }
            if (string.IsNullOrEmpty(demodel.Mobile)) {
                return ApiResult.ParamIsNull("请输入联系电话");
            }
            if ((demodel.Province ?? 0) <= 0 || (demodel.City ?? 0) <= 0 || (demodel.District ?? 0) <= 0) {
                return ApiResult.ParamIsNull("请选择区域");
            }
            if (string.IsNullOrEmpty(demodel.Address)) {
                return ApiResult.ParamIsNull("请输入详细地址");
            }

            demodel.IsDefault ??= 2;
            demodel.PostCode ??= "";
            demodel.Lonlat ??= "";
            demodel.Country ??= 2;
            demodel.UserId = userInfo.UserId;
            demodel.TenantId = userInfo.TenantId;
            demodel.MallBaseId = userInfo.MallBaseId;
            demodel.CreateDate = DateTime.Now;
            demodel.UpdateDate = DateTime.Now;
            demodel.Status = 0;

            bool flag = userModule.SetUserShippingAddress(demodel);
            if (flag)
            {
                return ApiResult.Success();
            }
            else {
                return ApiResult.Failed();
            }
        }

        /// <summary>
        /// 设置地址默认
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetUserShippingAddressDefault() {
            var req = RequestParm;
            var userInfo = AppletUserInfo;
            JObject prams = JObject.Parse(req.msg.ToString());
            int AddressId = prams.GetInt("AddressId", 0);
            if (AddressId <= 0) {
                return ApiResult.ParamIsNull();
            }

            bool flag = userModule.SetUserShippingAddressDefault(AddressId, userInfo.UserId);
            if (flag)
            {
                return ApiResult.Success();
            }
            else {
                return ApiResult.Failed();
            }
        }

        /// <summary>
        /// 删除地址
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult DelUserShippingAddress()
        {
            var req = RequestParm;
            var userInfo = AppletUserInfo;
            JObject prams = JObject.Parse(req.msg.ToString());
            int AddressId = prams.GetInt("AddressId", 0);
            if (AddressId <= 0)
            {
                return ApiResult.ParamIsNull();
            }

            bool flag = userModule.DelUserShippingAddressDefault(AddressId, userInfo.UserId);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }

        #endregion

        #region 收藏商品

        /// <summary>
        /// 获取收藏商品分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetUserCollectionPageList()
        {
            var req = RequestParm;
            var userInfo = AppletUserInfo;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(req.msg.ToString());
            RB_Goods_Extend demodel = JsonConvert.DeserializeObject<RB_Goods_Extend>(req.msg.ToString());

            demodel.UserId = userInfo.UserId;
            demodel.TenantId = userInfo.TenantId;
            demodel.MallBaseId = userInfo.MallBaseId;
            var list = userModule.GetUserCollectionPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.Id,
                x.Name,
                x.CoverImage,
                x.SellingPrice,
                x.SalesNum
            });

            return ApiResult.Success("", pagelist);
        }

        /// <summary>
        /// 用户收藏/取消收藏商品
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetUserCollectionInfo() {
            var req = RequestParm;
            var userInfo = AppletUserInfo;
            JObject parms = JObject.Parse(req.msg.ToString());
            int GoodsId = parms.GetInt("GoodsId", 0);
            if (GoodsId <= 0) {
                return ApiResult.ParamIsNull();
            }

            bool flag = userModule.SetUserCollectionInfo(GoodsId, userInfo.UserId, userInfo.TenantId, userInfo.MallBaseId);
            if (flag)
            {
                return ApiResult.Success();
            }
            else {
                return ApiResult.Failed();
            }
        }

        #endregion

        #region 分销中心

        /// <summary>
        /// 获取用户是否是分销商
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetUserDistrbutorStatus() {
            var userInfo = AppletUserInfo;

            var obj = userModule.GetUserDistrbutorStatus(userInfo.UserId, userInfo.TenantId, userInfo.MallBaseId);
            return ApiResult.Success("", obj);
        }

        /// <summary>
        /// 获取用户申请分销商页面信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetUserApplyForDistrbutorInfo() {
            var userInfo = AppletUserInfo;

            var obj = userModule.GetUserApplyForDistrbutorInfo(userInfo.UserId, userInfo.TenantId, userInfo.MallBaseId);
            return ApiResult.Success("", obj);
        }

        /// <summary>
        /// 用户申请成为分销商
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetUserApplyForBeDistrbutor() {
            var req = RequestParm;
            var userInfo = AppletUserInfo;
            RB_Distributor_Info_Extend demodel = JsonConvert.DeserializeObject<RB_Distributor_Info_Extend>(req.msg.ToString());
            if (string.IsNullOrEmpty(demodel.Name)) {
                return ApiResult.ParamIsNull("请输入名称");
            }
            if (string.IsNullOrEmpty(demodel.Mobile)) {
                return ApiResult.ParamIsNull("请输入手机号码");
            }

            demodel.TenantId = userInfo.TenantId;
            demodel.MallBaseId = userInfo.MallBaseId;
            demodel.UserId = userInfo.UserId;
            demodel.TotalCommission ??= 0;
            demodel.CommissionWithdrawal ??= 0;
            demodel.GradeId ??= 0;
            demodel.AuditStatus ??= DistributorAuditStatusEnum.Auditing;
            demodel.Status = 0;
            demodel.CreateDate = DateTime.Now;
            demodel.UpdateDate = DateTime.Now;
            bool flag = userModule.SetUserApplyForBeDistrbutor(demodel);
            if (flag) { return ApiResult.Success(); } else { return ApiResult.Failed(); }
        }

        /// <summary>
        /// 获取分销中心
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetUserDistrbutorCenter() {
            var userInfo = AppletUserInfo;

            var obj = userModule.GetDistrbutorCenter(userInfo);
            return ApiResult.Success("", obj);
        }

        /// <summary>
        /// 获取用户升级条件
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetUserDistrbutorUpgradeConditions() {
            var userInfo = AppletUserInfo;

            var obj = userModule.GetDistrbutorUpgradeConditions(userInfo);
            return ApiResult.Success("", obj);
        }

        /// <summary>
        /// 获取提现余额
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetUserDistrbutorWithdrawDepositBalance() {
            var userInfo = AppletUserInfo;

            var obj = userModule.GetDistrbutorWithdrawDepositBalance(userInfo);
            return ApiResult.Success("", obj);
        }

        /// <summary>
        /// 分销提现
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetUserDistrbutorWithdrawDeposit() {
            var req = RequestParm;
            var userInfo = AppletUserInfo;
            RB_Distributor_Remit_Extend demodel = JsonConvert.DeserializeObject<RB_Distributor_Remit_Extend>(req.msg.ToString());
            if ((demodel.AppliedMoney ?? 0) <= 0) {
                return ApiResult.ParamIsNull("提现金额不能小于0");
            }
            if (demodel.WithdrawalWay == DistrbutorWithdrawWayEnum.WXZZ || demodel.WithdrawalWay == DistrbutorWithdrawWayEnum.YYKZZ || demodel.WithdrawalWay == DistrbutorWithdrawWayEnum.ZFBZZ) {
                if (string.IsNullOrEmpty(demodel.AccountName)) {
                    return ApiResult.ParamIsNull("请输入账户名称");
                }
                if (string.IsNullOrEmpty(demodel.AccountNumber)) {
                    return ApiResult.ParamIsNull("请输入账号");
                }
                if (demodel.WithdrawalWay == DistrbutorWithdrawWayEnum.YYKZZ) {
                    if (string.IsNullOrEmpty(demodel.BankName)) {
                        return ApiResult.ParamIsNull("请输入银行名称");
                    }
                }
            }

            demodel.TenantId = userInfo.TenantId;
            demodel.MallBaseId = userInfo.MallBaseId;
            demodel.UserId = userInfo.UserId;
            demodel.AuditStatus = DistributorRemitAuditStatusEnum.Auditing;
            demodel.CreateDate = DateTime.Now;
            demodel.OrderNum = DateTime.Now.ToString("yyyyMMddHHmmssffff");
            string msg = userModule.SetDistrbutorWithdrawDeposit(demodel);
            if (msg == "")
            {
                return ApiResult.Success();
            }
            else {
                return ApiResult.Failed(msg);
            }
        }

        /// <summary>
        /// 获取分销佣金页面信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetUserDistrbutorCommissionInfo()
        {
            var userInfo = AppletUserInfo;

            var obj = userModule.GetDistrbutorCommissionInfo(userInfo);
            return ApiResult.Success("", obj);
        }

        /// <summary>
        /// 获取用户提现明细
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetUserDistrbutorRemitPageList() {
            var req = RequestParm;
            var userInfo = AppletUserInfo;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(req.msg.ToString());
            RB_Distributor_Remit_Extend demodel = JsonConvert.DeserializeObject<RB_Distributor_Remit_Extend>(req.msg.ToString());

            demodel.UserId = userInfo.UserId;
            demodel.TenantId = userInfo.TenantId;
            demodel.MallBaseId = userInfo.MallBaseId;
            var list = userModule.GetDistributorRemitPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.Id,
                x.OrderNum,
                x.WithdrawalWay,
                WithdrawalWayName = x.WithdrawalWay.GetEnumName(),
                x.AccountName,
                x.AccountNumber,
                x.BankName,
                x.AppliedMoney,
                x.Fee,
                x.RemitMoney,
                x.AuditRemark,
                x.RemitRemark,
                x.RejectRemark,
                x.AuditStatus,
                AuditStatusName = x.AuditStatus.GetEnumName(),                
                x.TenantId,
                CreateDate = x.CreateDate.HasValue ? x.CreateDate.Value.ToString("yyyy-MM-dd HH:mm:ss") : "",
                AuditDate = x.AuditDate.HasValue ? x.AuditDate.Value.ToString("yyyy-MM-dd HH:mm:ss") : "",
                RemitDate = x.RemitDate.HasValue ? x.RemitDate.Value.ToString("yyyy-MM-dd HH:mm:ss") : "",
                RejectDate = x.RejectDate.HasValue ? x.RejectDate.Value.ToString("yyyy-MM-dd HH:mm:ss") : "",
            });
            return ApiResult.Success("", pagelist);
        }

        /// <summary>
        /// 获取我的团队里 自定义信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetUserMyTeamCustomInfo() {
            var userInfo = AppletUserInfo;

            var obj = userModule.GetUserMyTeamCustomInfo(userInfo);
            return ApiResult.Success("", obj);
        }

        /// <summary>
        /// 获取分销商团队
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetUserMyTeamPageList() {
            var req = RequestParm;
            var userInfo = AppletUserInfo;
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(req.msg.ToString());
            RB_Distributor_Info_Extend demodel = JsonConvert.DeserializeObject<RB_Distributor_Info_Extend>(req.msg.ToString());

            demodel.TenantId = userInfo.TenantId;
            demodel.MallBaseId = userInfo.MallBaseId;
            demodel.UserId = userInfo.UserId;
            pageModel.pageData = userModule.GetUserMyTeamPageList(pageModel.pageIndex, pageModel.pageSize, out long count, demodel);
            pageModel.count = Convert.ToInt32(count);

            return ApiResult.Success("", pageModel);
        }
        //分销订单  提现明细  我的团队

        #endregion
    }
}