﻿using Mall.Model.Entity.MarketingCenter;
using Mall.Model.Extend.MarketingCenter;
using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;

namespace Mall.Repository.MarketingCenter
{
    /// <summary>
    /// 分享详情实体仓储层
    /// </summary>
    public class RB_Share_FriendRepository : BaseRepository<RB_Share_Friend>
    {
        /// <summary>
        /// 获取分享详情分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowsCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Share_Friend_Extend> GetShareFriendPageListRepository(int pageIndex, int pageSize, out long rowsCount, RB_Share_Friend_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM rb_share_friend
WHERE 1=1 AND Status=0
");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Share_Friend_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Share_Friend_Extend.MallBaseId)}={query.MallBaseId}");
                }
            }
            return GetPage<RB_Share_Friend_Extend>(pageIndex, pageSize, out rowsCount, builder.ToString()).ToList();
        }


        /// <summary>
        /// 获取分享详情列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Share_Friend_Extend> GetShareFriendListRepository(RB_Share_Friend_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM rb_share_friend
WHERE 1=1 AND Status=0
");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Share_Friend_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Share_Friend_Extend.MallBaseId)}={query.MallBaseId}");
                }
          
            }
            return Get<RB_Share_Friend_Extend>(builder.ToString()).ToList();
        }
    }
}