﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;
using Mall.Model.Entity.User;
using Mall.Common.Enum.Goods;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 商品订单返佣仓储层
    /// </summary>
    public class RB_SmallShops_CommissionRepository : BaseRepository<RB_SmallShops_Commission>
    {
        /// <summary>
        /// 获取微店返佣列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_SmallShops_Commission_Extend> GetList(RB_SmallShops_Commission_Extend dmodel)
        {
            string where = $" 1=1 and o.Recycled=2 and oa.ReOrderId is null";
            if (dmodel.TenantId > 0)
            {
                where += $@" and oc.{nameof(RB_SmallShops_Commission.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and oc.{nameof(RB_SmallShops_Commission.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.OrderId > 0)
            {
                where += $@" and oc.{nameof(RB_SmallShops_Commission.OrderId)}={dmodel.OrderId}";
            }
            if (dmodel.OrderDetailId > 0) 
            {
                where += $@" and oc.{nameof(RB_SmallShops_Commission.OrderDetailId)}={dmodel.OrderDetailId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and oc.{nameof(RB_SmallShops_Commission.UserId)}={dmodel.UserId}";
            }
            if (dmodel.SmallShopsId > 0)
            {
                where += $@" and o.{nameof(RB_Goods_Order.SmallShopsId)}={dmodel.SmallShopsId}";
            }
            if (!string.IsNullOrEmpty(dmodel.OrderIds))
            {
                where += $@" and oc.{nameof(RB_SmallShops_Commission.OrderId)} in({dmodel.OrderIds})";
            }
            if (dmodel.DistrbutionOrderSelectStatus > 0)
            {
                switch (dmodel.DistrbutionOrderSelectStatus)
                {
                    case 1: where += $@" and o.{nameof(RB_Goods_Order.OrderStatus)}={(int)OrderStatusEnum.NonPayment}"; break;
                    case 2: where += $@" and o.{nameof(RB_Goods_Order.OrderStatus)} in(2,3,4,6)"; break;
                    case 3: where += $@" and o.{nameof(RB_Goods_Order.OrderStatus)}={(int)OrderStatusEnum.Completed}"; break;
                }
            }
            else
            {
                where += $@" and o.{nameof(RB_Goods_Order.OrderStatus)} in(1,2,3,4,5,6)";
            }

            string sql = $@"SELECT oc.*
FROM RB_SmallShops_Commission oc
inner join rb_goods_orderdetail od on oc.OrderDetailId = od.Id
inner join rb_goods_order o on oc.OrderId = o.OrderId
left join rb_goods_orderaftersale oa on oc.OrderDetailId= oa.OrderDetialId and oa.Type=1 and oa.Status=0 and oa.ReOrderStatus in (2,3,4,5)
where {where} order by oc.OrderId desc";
            return Get<RB_SmallShops_Commission_Extend>(sql).ToList();
        }

        /// <summary>
        /// 获取用户返佣
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_SmallShops_Commission_Extend> GetListGroupByUser(RB_SmallShops_Commission_Extend dmodel)
        {
            string where = $" 1=1 and oa.ReOrderId is null";
            if (dmodel.TenantId > 0)
            {
                where += $@" and oc.{nameof(RB_SmallShops_Commission.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and oc.{nameof(RB_SmallShops_Commission.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.OrderId > 0)
            {
                where += $@" and oc.{nameof(RB_SmallShops_Commission.OrderId)}={dmodel.OrderId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and oc.{nameof(RB_SmallShops_Commission.UserId)}={dmodel.UserId}";
            }
            if (dmodel.OrderDetailId > 0)
            {
                where += $@" and oc.{nameof(RB_SmallShops_Commission.OrderDetailId)}={dmodel.OrderDetailId}";
            }
            if (!string.IsNullOrEmpty(dmodel.OrderIds))
            {
                where += $@" and oc.{nameof(RB_SmallShops_Commission.OrderId)} in({dmodel.OrderIds})";
            }

            string sql = $@"SELECT oc.OrderId,oc.UserId,oc.Type,oc.CommissionState,SUM(oc.Commission) as Commission FROM rb_smallshops_commission oc 
left join rb_goods_orderaftersale oa on oc.OrderDetailId= oa.OrderDetialId and oa.Type=1 and oa.Status=0 and oa.ReOrderStatus in (2,3,4,5)
where {where} group by oc.OrderId,oc.UserId,oc.Type ";
            return Get<RB_SmallShops_Commission_Extend>(sql).ToList();
        }

        /// <summary>
        /// 获取用户返佣
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_SmallShops_Commission_Extend> GetSmallShopsCommissionPageList(int pageIndex, int pageSize, out long count, RB_SmallShops_Commission_Extend dmodel)
        {
            string where = $" 1=1 and o.Recycled=2 and oa.ReOrderId is null";
            if (dmodel.TenantId > 0)
            {
                where += $@" and oc.{nameof(RB_SmallShops_Commission.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and oc.{nameof(RB_SmallShops_Commission.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.OrderId > 0)
            {
                where += $@" and oc.{nameof(RB_SmallShops_Commission.OrderId)}={dmodel.OrderId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and oc.{nameof(RB_SmallShops_Commission.UserId)}={dmodel.UserId}";
            }
            if (dmodel.SmallShopsId > 0)
            {
                where += $@" and o.{nameof(RB_Goods_Order.SmallShopsId)}={dmodel.SmallShopsId}";
            }
            if (!string.IsNullOrEmpty(dmodel.OrderIds))
            {
                where += $@" and oc.{nameof(RB_SmallShops_Commission.OrderId)} in({dmodel.OrderIds})";
            }
            if (dmodel.DistrbutionOrderSelectStatus > 0)
            {
                switch (dmodel.DistrbutionOrderSelectStatus)
                {
                    case 1: where += $@" and o.{nameof(RB_Goods_Order.OrderStatus)}={(int)OrderStatusEnum.NonPayment}"; break;
                    case 2: where += $@" and o.{nameof(RB_Goods_Order.OrderStatus)} in(2,3,4,6)"; break;
                    case 3: where += $@" and o.{nameof(RB_Goods_Order.OrderStatus)}={(int)OrderStatusEnum.Completed}"; break;
                }
            }
            else
            {
                where += $@" and o.{nameof(RB_Goods_Order.OrderStatus)} in(1,2,3,4,5,6)";
            }

            string sql = $@"SELECT GROUP_CONCAT(oc.OrderDetailId) as OrderDetailIds,oc.OrderId,o.OrderNo,o.UserId,oc.Type,oc.CommissionState,o.OrderStatus as DistrbutionOrderSelectStatus,SUM(oc.Commission) as Commission 
FROM RB_SmallShops_Commission oc
inner join rb_goods_orderdetail od on oc.OrderDetailId = od.Id
inner join rb_goods_order o on oc.OrderId = o.OrderId
left join rb_goods_orderaftersale oa on oc.OrderDetailId= oa.OrderDetialId and oa.Type=1 and oa.Status=0 and oa.ReOrderStatus in (2,3,4,5)
where {where} group by oc.OrderId,o.OrderNo,oc.UserId,oc.Type order by oc.OrderId desc";
            return GetPage<RB_SmallShops_Commission_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }

        /// <summary>
        /// 订单返佣
        /// </summary>
        /// <param name="userId"></param>
        /// <returns></returns>
        public decimal GetUserOrderCommissionStatistics(int userId)
        {
            string sql = $@"SELECT SUM(Commission) as Commission FROM RB_SmallShops_Commission oc
INNER JOIN rb_goods_order o on oc.OrderId=o.OrderId
left join rb_goods_orderaftersale oa on oc.OrderDetailId= oa.OrderDetialId and oa.Type=1 and oa.Status=0 and oa.ReOrderStatus in (2,3,4,5)
 WHERE oc.UserId={userId} and o.OrderStatus in (1,2,3,4,5,6) and o.Recycled=2 and oa.ReOrderId is null";

            var obj = ExecuteScalar(sql);
            if (obj != null)
            {
                return Convert.ToDecimal(obj);
            }
            return 0;
        }

        /// <summary>
        /// 获取未提现的佣金列表
        /// </summary>
        /// <param name="UserId"></param>
        /// <returns></returns>
        public List<RB_Goods_OrderCommission_Extend> GetUserCommissionRemit(int UserId)
        {
            string sql = $@"SELECT * FROM RB_SmallShops_Commission oc WHERE oc.CommissionState=2 and oc.UserId={UserId} and oc.IsRemit <> 1";
            return Get<RB_Goods_OrderCommission_Extend>(sql).ToList();
        }

        /// <summary>
        /// 获取已标记提现的佣金列表
        /// </summary>
        /// <param name="UserId"></param>
        /// <param name="OrderIds"></param>
        /// <returns></returns>
        public List<RB_Goods_OrderCommission_Extend> GetUserCommissionRemitedList(int UserId, string OrderIds)
        {
            string sql = $@"SELECT * FROM RB_SmallShops_Commission oc WHERE oc.CommissionState=2 and oc.UserId={UserId} and oc.OrderId in ({OrderIds}) and oc.IsRemit = 1";
            return Get<RB_Goods_OrderCommission_Extend>(sql).ToList();
        }
    }
}
