﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Extend.User;
using Mall.Repository;
using System.Linq;
using VT.FW.DB;

namespace Mall.Module.User
{
    /// <summary>
    /// 插件处理类
    /// </summary>
    public class PlugInModule
    {
        /// <summary>
        /// 插件仓储层对象
        /// </summary>
        private readonly Repository.User.RB_PlugInRepository plugInRepository = new Repository.User.RB_PlugInRepository();

        /// <summary>
        /// 根据查询条件获取插件列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_PlugIn_Extend> GetPlugInListModule(RB_PlugIn_Extend query)
        {
            return plugInRepository.GetListRepository(query);
        }

        /// <summary>
        /// 根据查询条件获取插件分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_PlugIn_Extend> GetPlugInPageModule(int pageIndex, int pageSize, out long rowsCount, RB_PlugIn_Extend query)
        {
            return plugInRepository.GetPlugInPageRepository(pageIndex, pageSize, out rowsCount, query);
        }

        /// <summary>
        /// 新增修改插件
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetPlugInModule(RB_PlugIn_Extend model)
        {
            bool flag = false;
            if (model.PlugId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_PlugIn_Extend.PlugType), model.PlugType},
                    { nameof(RB_PlugIn_Extend.Id), model.Id},
                    { nameof(RB_PlugIn_Extend.Name), model.Name},
                    { nameof(RB_PlugIn_Extend.Icon), model.Icon},
                };
                flag = plugInRepository.Update(fileds, new WhereHelper(nameof(RB_PlugIn_Extend.PlugId), model.PlugId));
            }
            else
            {
                var newId = plugInRepository.Insert(model);
                model.PlugId = newId;
                flag = newId > 0;
            }
            return flag;
        }


        /// <summary>
        /// 根据编号获取插件详情
        /// </summary>
        /// <param name="PlugId"></param>
        /// <returns></returns>
        public RB_PlugIn_Extend GetPlugInModule(int PlugId)
        {
            var model = GetPlugInPageModule(1, 1, out long rowsCount, new RB_PlugIn_Extend() { PlugId = PlugId })?.FirstOrDefault();
            return model;
        }


        /// <summary>
        /// 修改插件状态
        /// </summary>
        /// <param name="PlugId">插件编号</param>
        /// <param name="Status">插件状态(0-正常，1-删除)</param>
        /// <returns></returns>
        public bool SetPlugInStatusModule(int PlugId, int Status)
        {
            bool flag = false;
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                { nameof(RB_PlugIn_Extend.Status), Status},
            };
            flag = plugInRepository.Update(fileds, new WhereHelper(nameof(RB_PlugIn_Extend.PlugId), PlugId));
            return flag;
        }
    }
}
