﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.Education;
using Mall.Model.Extend.Education;
using VT.FW.DB.Dapper;

namespace Mall.Repository.Education
{

    /// <summary>
    /// 财务收据仓储层
    /// </summary>
    public class RB_Receipt_InfoRepository : BaseRepository<RB_Receipt_Info>
    {
        /// <summary>
        /// 获取分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Receipt_Info_ViewModel> GetPageList(int pageIndex, int pageSize, out long count, RB_Receipt_Info_ViewModel demodel)
        {
            DynamicParameters parameters = new DynamicParameters();
            string where = $@" 1=1 and r.Status =0";
            if (demodel.Group_Id > 0)
            {
                where += $@" and r.{nameof(RB_Receipt_Info_ViewModel.Group_Id)} ={demodel.Group_Id}";
            }
            if (demodel.FinanceId > 0)
            {
                where += $@" and r.{nameof(RB_Receipt_Info_ViewModel.FinanceId)} ={demodel.FinanceId}";
            }
            if (demodel.UserId > 0)
            {
                where += $@" and r.{nameof(RB_Receipt_Info_ViewModel.UserId)} ={demodel.UserId}";
            }
            if (demodel.State > 0)
            {
                where += $@" and r.{nameof(RB_Receipt_Info_ViewModel.State)} ={demodel.State}";
            }
            if (!string.IsNullOrEmpty(demodel.ReceiptNo))
            {
                where += $@" and r.{nameof(RB_Receipt_Info_ViewModel.ReceiptNo)} ='{demodel.ReceiptNo}'";
            }
            if (!string.IsNullOrEmpty(demodel.Remitter))
            {
                where += $@" and r.{nameof(RB_Receipt_Info_ViewModel.Remitter)} like @Remitter";
                parameters.Add("Remitter", "%" + demodel.Remitter + "%");
            }

            string sql = $@" 
SELECT * From RB_Receipt_Info r
WHERE {where} 
ORDER BY r.Id DESC ";
            return GetPage<RB_Receipt_Info_ViewModel>(pageIndex, pageSize, out count, sql, parameters).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Receipt_Info_ViewModel> GetList(RB_Receipt_Info_ViewModel demodel)
        {
            DynamicParameters parameters = new DynamicParameters();
            string where = $@" 1=1 and r.Status =0";
            if (demodel.Group_Id > 0)
            {
                where += $@" and r.{nameof(RB_Receipt_Info_ViewModel.Group_Id)} ={demodel.Group_Id}";
            }
            if (demodel.FinanceId > 0)
            {
                where += $@" and r.{nameof(RB_Receipt_Info_ViewModel.FinanceId)} ={demodel.FinanceId}";
            }
            if (demodel.State > 0)
            {
                where += $@" and r.{nameof(RB_Receipt_Info_ViewModel.State)} ={demodel.State}";
            }
            if (!string.IsNullOrEmpty(demodel.ReceiptNo))
            {
                where += $@" and r.{nameof(RB_Receipt_Info_ViewModel.ReceiptNo)} ='{demodel.ReceiptNo}'";
            }
            if (!string.IsNullOrEmpty(demodel.Remitter))
            {
                where += $@" and r.{nameof(RB_Receipt_Info_ViewModel.Remitter)} like @Remitter";
                parameters.Add("Remitter", "%" + demodel.Remitter + "%");
            }

            string sql = $@" 
SELECT * From RB_Receipt_Info r
WHERE {where} 
ORDER BY r.Id DESC ";
            return Get<RB_Receipt_Info_ViewModel>(sql, parameters).ToList();
        }

        /// <summary>
        /// 获取收据最大的编码
        /// </summary>
        /// <param name="group_Id"></param>
        /// <returns></returns>
        public string GetMaxReceiptNo(int group_Id)
        {
            string sql = "SELECT MAX(ReceiptNo) FROM rb_receipt_info WHERE `Status` =0 and Group_Id =" + group_Id;
            var obj = ExecuteScalar(sql);
            return obj == null ? "" : obj.ToString();
        }
    }
}
