﻿using Mall.Common.AOP;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 专题分类表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Topic_Type
    {
        /// <summary>
        /// 专题分类编号
        /// </summary>        
        public int Id
        {
            get;
            set;
        }

        /// <summary>
        /// 专题分类名称
        /// </summary>        
        public string TopicName
        {
            get;
            set;
        }

        /// <summary>
        /// 排序
        /// </summary>        
        public int? SortNum
        {
            get;
            set;
        }

        /// <summary>
        /// 禁用状态(0-禁用,1-启用)
        /// </summary>        
        public int? IsDisable
        {
            get;
            set;
        }

        /// <summary>
        /// 商户号Id
        /// </summary>        
        public int? TenantId
        {
            get;
            set;
        }

        /// <summary>
        /// 小程序Id
        /// </summary>        
        public int? MallBaseId
        {
            get;
            set;
        }

        /// <summary>
        /// 创建时间
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }

        /// <summary>
        /// 删除状态
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }
    }
}
