﻿
using MongoDB.Driver;
using System;
using System.Collections.Generic;
using System.Linq.Expressions;
using System.Text;

namespace Mall.CacheManager.Base
{
    /// <summary>
    /// Mogo缓存基类
    /// </summary>
    public class BaseMongoCached<T>
    {
        /// Mongo配置信息
        /// </summary>
        private MongoHelper MongoHelper
        {
            get; set;
        }

        public BaseMongoCached()
        {
            var ConnectionString = Mall.Common.Config.Mongo; //ConfigurationManager.AppSettings["Mongo"].ToString();
            var DatabaseName = Mall.Common.Config.MongoDBName;// ConfigurationManager.AppSettings["MongoDBName"].ToString();
            this.MongoHelper = new MongoHelper(new MongoConfig()
            {
                AutoCreateCollection = true,
                AutoCreateDb = true,
                CollectionName = typeof(T).Name,
                ConnectionString = ConnectionString,
                DatabaseName = DatabaseName
            });
        }


        /// <summary>
        /// 查询
        /// </summary>
        /// <typeparam name="TDoc">泛型约束</typeparam>
        /// <param name="filter">Expression表达式</param>
        /// <param name="options"></param>
        /// <returns></returns>
        public List<T> Find(Expression<Func<T, bool>> filter)
        {
            try
            {
                return MongoHelper.Find<T>(filter);
            }
            catch (Exception ex)
            {
                Mall.Common.Plugin.LogHelper.Write(ex, "BaseMongoCached_Find");
            }
            return new List<T>();
        }

        /// <summary>
        /// 新增一条【key相同的时候不能新增成功】
        /// </summary>
        /// <param name="doc">新对象</param>
        /// <returns>bool</returns>
        public bool Insert(T doc)
        {
            try
            {
                MongoHelper.Insert<T>(doc);
                return true;
            }
            catch
            {
                return false;
            }
        }

        /// <summary>
        /// 新增多条【key相同的时候不能新增成功】
        /// </summary>
        /// <param name="docs">新对象</param>
        public bool InsertMany(IEnumerable<T> docs)
        {
            try
            {
                MongoHelper.InsertMany<T>(docs);
                return true;
            }
            catch
            {
                return false;
            }
        }

        /// <summary>
        /// 更新一条
        /// </summary>
        /// <param name="doc">新对象</param>
        /// <param name="filter">Expression表达式</param>
        /// <param name="options"></param>
        public bool Update(T doc, Expression<Func<T, bool>> filter)
        {
            try
            {
                MongoHelper.Update<T>(doc, filter);
                return true;
            }
            catch (Exception ex)
            {
                Mall.Common.Plugin.LogHelper.Write(ex, "BaseMongoCached_Update");
                return false;
            }
        }


        /// <summary>
        /// 更新一条【扩展】
        /// </summary>
        /// <param name="doc">新对象</param>
        /// <param name="filter">Expression表达式</param>
        /// <param name="options"></param>
        public bool UpdateExt(T doc, Expression<Func<T, bool>> filter)
        {
            try
            {
                MongoHelper.UpdateExt<T>(doc, filter);
                return true;
            }
            catch (Exception ex)
            {
                Mall.Common.Plugin.LogHelper.Write(ex, "BaseMongoCached_UpdateExt");
                return false;
            }
        }

        /// <summary>
        /// 更新多条
        /// </summary>
        /// <param name="doc">新对象</param>
        /// <param name="filter">Expression表达式</param>
        public bool UpdateMany(T doc, Expression<Func<T, bool>> filter)
        {
            try
            {
                MongoHelper.UpdateMany<T>(doc, filter);
                return true;
            }
            catch (Exception ex)
            {
                Mall.Common.Plugin.LogHelper.Write(ex, "BaseMongoCached_UpdateMany");
                return false;
            }
        }

        /// <summary>
        /// 删除一条
        /// </summary>
        /// <param name="filter">Expression表达式</param>
        public bool Delete(Expression<Func<T, bool>> filter)
        {
            try
            {
                MongoHelper.Delete<T>(filter);
                return true;
            }
            catch (Exception ex)
            {
                Mall.Common.Plugin.LogHelper.Write(ex, "BaseMongoCached_Delete");
                return false;
            }
        }

        /// <summary>
        /// 删除多条
        /// </summary>
        /// <param name="filter">Expression表达式</param>
        public bool DeleteMany(Expression<Func<T, bool>> filter)
        {
            try
            {
                MongoHelper.DeleteMany<T>(filter);
                return true;
            }
            catch (Exception ex)
            {
                Mall.Common.Plugin.LogHelper.Write(ex, "BaseMongoCached_DeleteMany");
                return false;
            }

        }

        /// <summary>
        /// 清空集合对象
        /// </summary>
        [Obsolete]
        public bool ClearCollection()
        {
            try
            {
                MongoHelper.ClearCollection<T>();
                return true;
            }
            catch (Exception ex)
            {
                Mall.Common.Plugin.LogHelper.Write(ex, "BaseMongoCached_ClearCollection");
                return false;
            }
        }

        /// <summary>
        /// 获取集合
        /// </summary>
        /// <returns></returns>
        public IMongoCollection<T> GetCollection()
        {
            return MongoHelper.GetMongoCollection<T>();
        }
    }
}
