﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Plugin;

namespace Mall.Common.Enum.Education
{
    public enum ConsultOrderExportEnum
    {
        /// <summary>
        /// 订单号
        /// </summary>
        [EnumField("订单号")]
        OrderId = 1,

        /// <summary>
        /// 联系人
        /// </summary>
        [EnumField("联系人")]
        LinkMan = 2,
        /// <summary>
        /// 联系电话
        /// </summary>
        [EnumField("联系电话")]
        LinkTel = 3,
        /// <summary>
        /// 单价
        /// </summary>
        [EnumField("单价")]
        UnitPrice = 4,
        /// <summary>
        /// 应收
        /// </summary>
        [EnumField("应收")]
        Money = 5,
        /// <summary>
        /// 实收
        /// </summary>
        [EnumField("实收")]
        Income = 6,
        /// <summary>
        /// 退款
        /// </summary>
        [EnumField("退款")]
        RefundPrice = 7,
        /// <summary>
        /// 平台税金
        /// </summary>
        [EnumField("平台税金")]
        PlatformTax = 8,
        /// <summary>
        /// 待收金额
        /// </summary>
        [EnumField("待收金额")]
        DueInMoney = 9,
        /// <summary>
        /// 状态
        /// </summary>
        [EnumField("状态")]
        Status = 10,

        /// <summary>
        /// 备注
        /// </summary>
        [EnumField("备注")]
        Remark = 11,
        /// <summary>
        /// 报名时间
        /// </summary>
        [EnumField("报名时间")]
        CreateTime = 12

    }
}
