﻿using VT.FW.DB;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.BaseSetUp
{
    /// <summary>
    /// 小程序基础设置
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_MallBase
    {
        /// <summary>
        /// 编号
        /// </summary>
        public int ID { get; set; }

        public int MallBaseId { get; set; }

        /// <summary>
        /// 联系号码
        /// </summary>
        public string ContactNumber { get; set; }

        /// <summary>
        /// 外链客服链接
        /// </summary>
        public string OuterServiceLink { get; set; }
        /// <summary>
        /// 详细地址
        /// </summary>
        public string Address { get; set; }

        /// <summary>
        ///经纬度
        /// </summary>
        public string LongAndLat { get; set; }

        /// <summary>
        /// 跳转小程序-小程序appId
        /// </summary>
        public string MinAppId { get; set; }

        /// <summary>
        /// 跳转小程序-小程序路径
        /// </summary>
        public string MinUrl { get; set; }

        /// <summary>
        /// 未支付订单超时时间 （分钟）
        /// </summary>
        public int CancelTime { get; set; }

        /// <summary>
        /// 自动确认收货时间(天)
        /// </summary>
        public int AutoReceiving { get; set; }

        /// <summary>
        /// 售后时间(天)
        /// </summary>
        public int AfterTime { get; set; }
        /// <summary>
        /// 支付方式 
        /// </summary>
        public string PayWay { get; set; }

        /// <summary>
        /// 发货方式 
        /// </summary>
        public string DeliverWay { get; set; }

        /// <summary>
        /// 余额功能
        /// </summary>
        public int BalanceFun { get; set; }

        /// <summary>
        /// 储值卡功能
        /// </summary>
        public int DepositFun { get; set; }

        /// <summary>
        /// 商品面议联系方式
        /// </summary>
        public string ConsultWay { get; set; }

        /// <summary>
        /// 小程序开关
        /// </summary>
        public int MinSwitch { get; set; }

        /// <summary>
        /// 小程序背影颜色
        /// </summary>
        public string MinBackColor { get; set; }

        /// <summary>
        /// 小程序背影透明度
        /// </summary>
        public int MinBackClarity { get; set; }

        /// <summary>
        /// 小程序背景框圆角
        /// </summary>
        public int MinBackCircularBead { get; set; }

        /// <summary>
        /// 小程序提示文本内容 
        /// </summary>
        public string MinTips { get; set; }
        /// <summary>
        /// 小程序文本颜色
        /// </summary>
        public string MinTipsColor { get; set; }

        /// <summary>
        /// 小程序图标颜色
        /// </summary>
        public int MinIcoColor { get; set; }

        /// <summary>
        /// 转发标题
        /// </summary>
        public string MinShareTitle { get; set; }
        /// <summary>
        ///转发图标
        /// </summary>
        public string MinShareIco { get; set; }

        /// <summary>
        /// 首页购买记录框-开关
        /// </summary>

        public int BuySwitch { get; set; }

        /// <summary>
        /// 轮播订单数
        /// </summary>
        public int CarouselOrder { get; set; }

        /// <summary>
        /// 购物车
        /// </summary>
        public int ListShopCar { get; set; }

        /// <summary>
        /// 已售量
        /// </summary>
        public int ListBuyCount { get; set; }
        /// <summary>
        /// 商品名称
        /// </summary>
        public int ListName { get; set; }

        /// <summary>
        ///商城评论
        /// </summary>
        public int DetailsComment { get; set; }

        /// <summary>
        ///划线价
        /// </summary>
        public int DetailsLineationPrice { get; set; }

        /// <summary>
        /// 普通用户会员价
        /// </summary>
        public int DetailsMemberPrice { get; set; }

        /// <summary>
        /// 会员用户会员价
        /// </summary>
        public int DetailsVipMemberPrice { get; set; }

        /// <summary>
        /// 快递
        /// </summary>
        public int DeatilsExpress { get; set; }
        /// <summary>
        /// 已售量
        /// </summary>
        public int DetailsBuyNum { get; set; }

        /// <summary>
        /// 分销价
        /// </summary>
        public int DetailsSharePrice { get; set; }

        /// <summary>
        /// 商品视频特色样式开关
        /// </summary>
        public int DetailsVideo { get; set; }

        /// <summary>
        /// 非分销商分销中心显示
        /// </summary>
        public int OtherNoShare { get; set; }

        /// <summary>
        /// 首页授权手机号
        /// </summary>
        public int OtherIndexMoblie { get; set; }
        /// <summary>
        /// 手动授权手机号
        /// </summary>
        public int OtherManualMobile { get; set; }
        /// <summary>
        /// 关联公众号组件
        /// </summary>
        public int OtherTencent { get; set; }

        /// <summary>
        /// 会员等级标识
        /// </summary>
        public int OtherMemerLevel { get; set; }

        /// <summary>
        /// 定位地址是否必填
        /// </summary>
        public int OtherMustAddress { get; set; }

        /// <summary>
        /// 申请分销商提示弹窗
        /// </summary>
        public int OtherApplyShare { get; set; }
        /// <summary>
        /// 启用悬浮按钮
        /// </summary>
        public int SuspendBtn { get; set; }


        /// <summary>
        /// 1-展开收起，2-固定展开
        /// </summary>
        public int SuspendStyle { get; set; }


        /// <summary>
        /// 展开图标
        /// </summary>
        public string UnfoldIco { get; set; }


        /// <summary>
        /// 收起图标
        /// </summary>
        public string PackUpIco { get; set; }

        /// <summary>
        /// 在线客服开关，0-否，1-是
        /// </summary>
        public int OnlineService { get; set; }

        /// <summary>
        /// 在线客服图标
        /// </summary>
        public string OnlineServiceIco { get; set; }

        /// <summary>
        /// 返回首页导航开关，0-否，1-是
        /// </summary>

        public int BackTopNavigation { get; set; }

        /// <summary>
        /// 返回首页导航图标
        /// </summary>

        public string BackTopNavigationIco { get; set; }

        /// <summary>
        /// 一键拨号开关
        /// </summary>
        public int OneCall { get; set; }

        /// <summary>
        /// 一键拨号开关图标
        /// </summary>
        public string OneCallIco { get; set; }

        /// <summary>
        /// 客服外链开关
        /// </summary>
        public int ServiceOutLink { get; set; }
        /// <summary>
        /// 客服外链图标
        /// </summary>
        public string ServiceOutLinkIco { get; set; }

        /// <summary>
        /// 快捷导航开关
        /// </summary>
        public int ShortcutNavigation { get; set; }

        /// <summary>
        /// 快捷导航图标
        /// </summary>
        public string ShortcutNavigationIco { get; set; }

        /// <summary>
        /// 跳转小程序开关
        /// </summary>
        public int TurnMini { get; set; }

        /// <summary>
        /// 跳转小程序图标
        /// </summary>
        public string TurnMiniIco { get; set; }


        /// <summary>
        /// 自定义按钮
        /// </summary>
        public int Custom { get; set; }

        /// <summary>
        /// 跳转链接
        /// </summary>
        public string TurnLink { get; set; }

        /// <summary>
        /// 图标
        /// </summary>
        public int TurnIco { get; set; }

        /// <summary>
        /// 启用回到顶部悬浮按钮
        /// </summary>
        public int BackTopBtn { get; set; }

        /// <summary>
        /// 启用购物车悬浮按钮
        /// </summary>
        public int CarSuspendBtn { get; set; }
        /// <summary>
        /// 售罄图标显示开关
        /// </summary>
        public int SellOutIcoSwitch { get; set; }

        /// <summary>
        /// 是否使用默认图标
        /// </summary>
        public int SellOutDefaultIco { get; set; }

        /// <summary>
        /// 商品图正常尺寸
        /// </summary>
        public string GoodsNormalPic { get; set; }

        /// <summary>
        /// 商品图4:3尺寸
        /// </summary>
        public string GoodsZoomPic { get; set; }

        /// <summary>
        /// 商户号
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 是否开启全局分类包邮规则
        /// </summary>
        public int IsFreeShipping { get; set; }

        /// <summary>
        /// 查看微信次数
        /// </summary>
        public int LookWeChatTimes { get; set; }

        /// <summary>
        /// 是否开启引导页(1-是)
        /// </summary>
        public int IsOpenGuide { get; set; }
    }
}
