﻿using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Entity.Coffee
{

    /// <summary>
    /// 用户咖啡劵消费信息
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Member_CoffeeLog
    {
        /// <summary>
        /// Id
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 用户ID
        /// </summary>
        public int UserId { get; set; }

        /// <summary>
        /// 类型  1存入   2消费
        /// </summary>
        public int Type { get; set; }

        /// <summary>
        /// 数量
        /// </summary>
        public int Number { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        public string Remark { get; set; }

        /// <summary>
        /// 小程序Id
        /// </summary>        
        public int MallBaseId { get; set; }

        /// <summary>
        /// 创建人
        /// </summary>
        public int CreateBy { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>        
        public DateTime CreateDate { get; set; }

        /// <summary>
        /// 消费类型   1免费的   2使用购买的  (方便以后核对)
        /// </summary>
        public int BuyType { get; set; }

        /// <summary>
        /// 核销唯一标识  (可以根据 消费的数量来)
        /// </summary>
        public string Code { get; set; }

        /// <summary>
        /// 购买关联订单信息
        /// </summary>
        public int OrderId { get; set; }
    }
}
