﻿using Mall.Common.Enum;
using Mall.Common.Enum.TradePavilion;
using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Entity.TradePavilion
{
    /// <summary>
    /// 自定义表单实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Custom_Form
    {
		/// <summary>
		/// 主键
		/// </summary>
		public int Id { get; set; }

		/// <summary>
		/// 表单名称
		/// </summary>
		public string FormName { get; set; }

		/// <summary>
		/// 表单类型(见枚举)
		/// </summary>
		public ListTypeEnum FormType { get; set; }

		/// <summary>
		/// 表单内容
		/// </summary>
		public string FormData { get; set; }

		/// <summary>
		/// 商户号id
		/// </summary>
		public int TenantId { get; set; }

		/// <summary>
		/// 小程序id
		/// </summary>
		public int MallBaseId { get; set; }

		/// <summary>
		/// 创建人
		/// </summary>
		public int CreateBy { get; set; }

		/// <summary>
		/// 创建时间
		/// </summary>
		public DateTime CreateDate { get; set; }

		/// <summary>
		/// 修改人
		/// </summary>
		public int UpdateBy { get; set; }

		/// <summary>
		/// 修改时间
		/// </summary>
		public DateTime UpdateDate { get; set; }

		/// <summary>
		/// 删除状态
		/// </summary>
		public DateStateEnum Status { get; set; }
	}
}
