﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Common;
using Mall.Common.Plugin;
using Newtonsoft.Json;
using Mall.Common.API;
using Newtonsoft.Json.Linq;
using VT.FW.DB;
using Mall.Repository.Miai;
using Mall.Model.Extend.Miai;

namespace Mall.Module.Miai
{
    /// <summary>
    /// 相亲处理层
    /// </summary>
    public class MiaiCommonModule
    {
        /// <summary>
        /// 消息
        /// </summary>
        private readonly RB_Miai_MessageRepository miai_MessageRepository = new RB_Miai_MessageRepository();


        #region 消息通知
        /// <summary>
        /// 获取分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Miai_Message_Extend> GetPageList(int pageIndex, int pageSize, out long count, RB_Miai_Message_Extend dmodel)
        {
            return miai_MessageRepository.GetPageList(pageIndex, pageSize, out count, dmodel);
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Miai_Message_Extend> GetList(RB_Miai_Message_Extend dmodel) {
            return miai_MessageRepository.GetList(dmodel);
        }

        /// <summary>
        /// 新增消息
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public bool SetMessage(RB_Miai_Message_Extend dmodel)
        {
            return miai_MessageRepository.Insert(dmodel) > 0;
        }

        /// <summary>
        /// 获取消息数量
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public int GetMessageNum(RB_Miai_Message_Extend dmodel)
        {
            return miai_MessageRepository.GetMessageNum(dmodel);
        }

        /// <summary>
        /// 获取最新的一条记录
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public RB_Miai_Message_Extend GetNewMessageInfo(RB_Miai_Message_Extend dmodel)
        {
            return miai_MessageRepository.GetNewMessageInfo(dmodel);
        }

        /// <summary>
        /// 删除消息
        /// </summary>
        /// <param name="Id"></param>
        /// <returns></returns>
        public bool DelMessage(int Id) {
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_Miai_Message_Extend.Status),1},
                { nameof(RB_Miai_Message_Extend.UpdateDate),DateTime.Now},
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                 new WhereHelper(){
                     FiledName=nameof(RB_Miai_Message_Extend.Id),
                      FiledValue=Id,
                       OperatorEnum=OperatorEnum.Equal
                 }
            };
            return miai_MessageRepository.Update(keyValues, wheres);
        }

        /// <summary>
        /// 批量清除
        /// </summary>
        /// <param name="type"></param>
        /// <param name="userInfo"></param>
        /// <returns></returns>
        internal bool DelMiaiMessageInfoBatch(string type, AppletUserInfo userInfo)
        {
            return miai_MessageRepository.DelMiaiMessageInfoBatch(type, userInfo.UserId);
        }

        /// <summary>
        /// 获取访客统计
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        internal RB_Miai_Message_Extend GetMiaiMessageVisitorStatistics(int userId, int type, int tenantId, int mallBaseId)
        {
            return miai_MessageRepository.GetMiaiMessageVisitorStatistics(userId, type, tenantId, mallBaseId);
        }
        #endregion
    }
}
