﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.Coffee;
using Mall.Model.Extend.Education;
using VT.FW.DB.Dapper;

namespace Mall.Repository.Education
{

    /// <summary>
    /// 教育商品订单明细仓储
    /// </summary>
    public class RB_EduGoods_OrderDetailRepository : BaseRepository<RB_Goods_OrderDetail>
    {
        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Goods_OrderDetail_ViewModel> GetList(RB_Goods_OrderDetail_ViewModel demodel)
        {
            var parameters = new DynamicParameters();
            string where = $@" 1=1 and Status =0";

            if (demodel.Group_Id > 0)
            {
                where += $@" and {nameof(RB_Goods_OrderDetail_ViewModel.Group_Id)} ={demodel.Group_Id}";
            }
            if (demodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Goods_OrderDetail_ViewModel.MallBaseId)} ={demodel.MallBaseId}";
            }
            if (demodel.OrderId > 0)
            {
                where += $@" and {nameof(RB_Goods_OrderDetail_ViewModel.OrderId)} ={demodel.OrderId}";
            }
            if (demodel.MallOrderId > 0)
            {
                where += $@" and {nameof(RB_Goods_OrderDetail_ViewModel.MallOrderId)} ={demodel.MallOrderId}";
            }
            if (!string.IsNullOrEmpty(demodel.OrderIds))
            {
                where += $@" and {nameof(RB_Goods_OrderDetail_ViewModel.OrderId)} in({demodel.OrderIds})";
            }

            string sql = $@" select * from RB_Goods_OrderDetail where {where} order by Id desc";
            return Get<RB_Goods_OrderDetail_ViewModel>(sql, parameters).ToList();
        }
    }
}
