﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.Point;
using Mall.Model.Extend.Point;

namespace Mall.Repository.Point
{
    /// <summary>
    /// 点数产品仓储
    /// </summary>
    public class RB_Point_GoodsRepository : BaseRepository<RB_Point_Goods>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Point_Goods); } }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Point_Goods_Extend> GetPointGoodsList(RB_Point_Goods_Extend where)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append($@"SELECT * from RB_Point_Goods  where state=0");
            if (where != null)
            {
                if (where.TenantId > 0)
                {
                    sb.AppendFormat(" and TenantId={0}", where.TenantId);
                }
                if (where.MallBaseId > 0)
                {
                    sb.AppendFormat(" and MallBaseId={0}", where.MallBaseId);
                }
                if (where.ID > 0)
                {
                    sb.AppendFormat(" and ID={0}", where.ID);
                }

                if (!string.IsNullOrWhiteSpace(where.GoodsName))
                {
                    sb.AppendFormat(" and GoodsName like'%{0}%'", where.GoodsName);
                }

            }
            return Get<RB_Point_Goods_Extend>(sb.ToString()).ToList();
        }




        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Point_Goods_Extend> GetPointGoodsPageList(int pageIndex, int pageSize, out long rowsCount, RB_Point_Goods_Extend where)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append($@"SELECT * from RB_Point_Goods  where state=0");
            if (where != null)
            {
                if (where.TenantId > 0)
                {
                    sb.AppendFormat(" and TenantId={0}", where.TenantId);
                }
                if (where.MallBaseId > 0)
                {
                    sb.AppendFormat(" and MallBaseId={0}", where.MallBaseId);
                }
                if (where.ID > 0)
                {
                    sb.AppendFormat(" and ID={0}", where.ID);
                }

                if (!string.IsNullOrWhiteSpace(where.GoodsName))
                {
                    sb.AppendFormat(" and GoodsName like'%{0}%'", where.GoodsName);
                }
            }
            return GetPage<RB_Point_Goods_Extend>(pageIndex, pageSize, out rowsCount, sb.ToString()).ToList();
        }
    }
}
