﻿using Mall.Common.Enum;
using Mall.Model.Entity.TradePavilion;
using Mall.Model.Extend.TradePavilion;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Mall.Repository.TradePavilion
{
    /// <summary>
    /// 企业服务仓储层
    /// </summary>
    public class RB_EnterpriseServicesRepository : BaseRepository<RB_EnterpriseServices>
    {
        /// <summary>
        /// 获取企业服务分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_EnterpriseServices_Extend> GetEnterpriseServicesPageRepository(int pageIndex, int pageSize, out long rowsCount, RB_EnterpriseServices_Extend query)
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.*,IFNULL(B.ClassName,'') AS CategoryName
FROM rb_enterpriseservices AS A LEFT JOIN rb_brandclass AS B ON A.CategoryId=B.ID
WHERE 1=1
");
            builder.AppendFormat(@" AND A.{0}={1} ", nameof(RB_EnterpriseServices_Extend.Status), (int)DateStateEnum.Normal);
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(@" AND A.{0}={1} ", nameof(RB_EnterpriseServices_Extend.TenantId),query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(@" AND A.{0}={1} ", nameof(RB_EnterpriseServices_Extend.MallBaseId), query.MallBaseId);
                }
                if (query.CategoryId > 0)
                {
                    builder.AppendFormat(@" AND A.{0}={1} ", nameof(RB_EnterpriseServices_Extend.CategoryId), query.CategoryId);
                }


                if (!string.IsNullOrEmpty(query.Name))
                {
                    builder.AppendFormat(@" AND A.{0} LIKE @Name ", nameof(RB_EnterpriseServices_Extend.Name));
                    parameters.Add("@Name", "%" + query.Name + "%");
                }
            }
            builder.AppendFormat(" ORDER BY A.{0} DESC ", nameof(RB_EnterpriseServices_Extend.ServiceId));
            return GetPage<RB_EnterpriseServices_Extend>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }


        /// <summary>
        /// 【商载通】获取楼宇、载体列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_EnterpriseServices_Extend> GetEnterpriseServicesListRepository(RB_EnterpriseServices_Extend query)
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.*,IFNULL(B.ClassName,'') AS CategoryName
FROM rb_enterpriseservices AS A LEFT JOIN rb_brandclass AS B ON A.CategoryId=B.ID
WHERE 1=1
");
            builder.AppendFormat(@" AND A.{0}={1} ", nameof(RB_EnterpriseServices_Extend.Status), (int)DateStateEnum.Normal);
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(@" AND A.{0}={1} ", nameof(RB_EnterpriseServices_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(@" AND A.{0}={1} ", nameof(RB_EnterpriseServices_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrWhiteSpace(query.SelectIds))
                {
                    builder.AppendFormat(@" AND A.{0} in ({1}) ", nameof(RB_EnterpriseServices_Extend.ServiceId), query.SelectIds);
                }
                if (query.CategoryId > 0)
                {
                    builder.AppendFormat(@" AND A.{0}={1} ", nameof(RB_EnterpriseServices_Extend.CategoryId), query.CategoryId);
                }
                if (query.UserId > 0)
                {
                    builder.AppendFormat(@" AND A.{0}={1} ", nameof(RB_EnterpriseServices_Extend.UserId), query.UserId);
                }
                if (!string.IsNullOrEmpty(query.Name))
                {
                    builder.AppendFormat(@" AND A.{0} LIKE @Name ", nameof(RB_EnterpriseServices_Extend.Name));
                    parameters.Add("@Name", "%" + query.Name + "%");
                }
            }
            builder.AppendFormat(" ORDER BY A.{0} DESC ", nameof(RB_EnterpriseServices_Extend.ServiceId));
            return Get<RB_EnterpriseServices_Extend>(builder.ToString(), parameters).ToList();
        }

    }
}
