﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Mall.Common
{
    /// <summary>
    /// web端登录用户信息缓存
    /// </summary>
    public class UserInfo
    {
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }

        /// <summary>
        /// 小程序Id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }

        /// <summary>
        /// 是否开启校园版(1-开启)
        /// </summary>
        public int IsOpenSchool { get; set; }

        /// <summary>
        /// 是否是韩国馆版本(1-是)
        /// </summary>
        public int IsKorea { get; set; }

        /// <summary>
        /// 账号
        /// </summary>        
        public string Account
        {
            get;
            set;
        }


        /// <summary>
        /// 姓名/企业名称
        /// </summary>        
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// 手机号码
        /// </summary>        
        public string MobilePhone
        {
            get;
            set;
        }

        /// <summary>
        /// 微信号
        /// </summary>        
        public string WeChatNum
        {
            get;
            set;
        }


        /// <summary>
        /// 是否永久有效(0-默认，1-永久有效)
        /// </summary>        
        public int? IsEffective
        {
            get;
            set;
        }

        /// <summary>
        /// 账号有效期
        /// </summary>        
        public DateTime? AccountValidate
        {
            get;
            set;
        }

        /// <summary>
        /// 可创建小程序数量
        /// </summary>        
        public int? CreateMiniPrograme
        {
            get;
            set;
        }

        /// <summary>
        /// 商城名称
        /// </summary>        
        public string MallName
        {
            get;
            set;
        }

        /// <summary>
        /// 账号状态(0-默认，1-提交申请，2-审核通过，3-审核拒绝）
        /// </summary>        
        public int? AccountStatus
        {
            get;
            set;
        }

        /// <summary>
        /// token
        /// </summary>
        public string Token { get; set; }

        /// <summary>
        /// SecretKey
        /// </summary>
        public string SecretKey { get; set; }

        /// <summary>
        /// 员工编号
        /// </summary>
        public int EmpId { get; set; }

        /// <summary>
        /// 修改他人商品角色权限
        /// </summary>
        public int IsOtherUpdateGoods { get; set; }

        public string erptoken { get; set; }

        /// <summary>
        /// erp用户id
        /// </summary>
        public int ERPEmpId { get; set; }
        /// <summary>
        /// erp公司id
        /// </summary>
        public int ERPBranchId { get; set; }
        /// <summary>
        /// erp集团id
        /// </summary>
        public int ERPGroupId { get; set; }

    }

    public class MiniAppUserCache
    { 
        /// <summary>
        /// 用户OpenId
        /// </summary>
       public string UserOpenId { get; set; }

        /// <summary>
        /// 用户UnionId
        /// </summary>
        public string UserUnoinid { get; set; }
    }
}
