﻿using VT.FW.DB;
using Mall.Common.Enum.Goods;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.Product
{
    /// <summary>
    /// 商品表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Goods
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 商品名称
        /// </summary>        
        public string Name
        {
            get;
            set;
        }
        /// <summary>
        /// 轮播图  json 格式  第一张为封面图
        /// </summary>        
        public string CarouselImage
        {
            get;
            set;
        }
        /// <summary>
        /// 视频地址
        /// </summary>        
        public string VideoAddress
        {
            get;
            set;
        }
        /// <summary>
        /// 自定义分享标题
        /// </summary>        
        public string CustomShareTitles
        {
            get;
            set;
        }
        /// <summary>
        /// 自定义分享图片
        /// </summary>        
        public string CustomShareImage
        {
            get;
            set;
        }
        /// <summary>
        /// 商品状态   1销售中  2下架中
        /// </summary>        
        public int? GoodsStatus
        {
            get;
            set;
        }
        /// <summary>
        /// 库存数量
        /// </summary>        
        public int? InventoryNum
        {
            get;
            set;
        }
        /// <summary>
        /// 默认规格名
        /// </summary>        
        public string DefaultSpecificationName
        {
            get;
            set;
        }
        /// <summary>
        /// 是否自定义规格  1是  2否
        /// </summary>        
        public int? IsCustomSpecification
        {
            get;
            set;
        }
        /// <summary>
        /// 排序
        /// </summary>        
        public int? Sort
        {
            get;
            set;
        }
        /// <summary>
        /// 售价
        /// </summary>        
        public decimal? SellingPrice
        {
            get;
            set;
        }
        /// <summary>
        /// 原价
        /// </summary>        
        public decimal? OriginalPrice
        {
            get;
            set;
        }
        /// <summary>
        /// 单位
        /// </summary>        
        public string Unit
        {
            get;
            set;
        }
        /// <summary>
        /// 成本价格
        /// </summary>        
        public decimal? CostPrice
        {
            get;
            set;
        }
        /// <summary>
        /// 商品面议  1是  2否
        /// </summary>        
        public int? IsGoodsNegotiable
        {
            get;
            set;
        }
        /// <summary>
        /// 已售出数量
        /// </summary>        
        public int? SalesNum
        {
            get;
            set;
        }
        /// <summary>
        /// 商品货号
        /// </summary>        
        public string GoodsNumbers
        {
            get;
            set;
        }
        /// <summary>
        /// 商品重量   克
        /// </summary>        
        public int? GoodsWeight
        {
            get;
            set;
        }
        /// <summary>
        /// 是否默认服务  1是  2否
        /// </summary>        
        public int? IsDefaultService
        {
            get;
            set;
        }
        /// <summary>
        /// 商品服务  json格式
        /// </summary>        
        public string GoodsService
        {
            get;
            set;
        }
        /// <summary>
        /// 运费设置
        /// </summary>        
        public int? FreightId
        {
            get;
            set;
        }
        /// <summary>
        /// 自定义表单
        /// </summary>        
        public int? FormsId
        {
            get;
            set;
        }
        /// <summary>
        /// 限购商品数量
        /// </summary>        
        public int? LimitBuyGoodsNum
        {
            get;
            set;
        }
        /// <summary>
        /// 限购订单数量
        /// </summary>        
        public int? LimitBuyOrderNum
        {
            get;
            set;
        }
        /// <summary>
        /// 单品满件包邮
        /// </summary>        
        public int? FullNumPinkage
        {
            get;
            set;
        }
        /// <summary>
        /// 单品满额包邮
        /// </summary>        
        public decimal? FullMoneyPinkage
        {
            get;
            set;
        }
        /// <summary>
        /// 是否区域购买  1是  2否
        /// </summary>        
        public int? IsAreaBuy
        {
            get;
            set;
        }
        /// <summary>
        /// 积分赠送
        /// </summary>        
        public int? IntegralPresent
        {
            get;
            set;
        }
        /// <summary>
        /// 赠送类型  2固定值  1百分比
        /// </summary>        
        public int? IntegralPresentType
        {
            get;
            set;
        }
        /// <summary>
        /// 积分抵扣 
        /// </summary>        
        public decimal? PointsDeduction
        {
            get;
            set;
        }
        /// <summary>
        /// 抵扣类型  2固定值  1百分比
        /// </summary>        
        public int? PointsDeductionType
        {
            get;
            set;
        }
        /// <summary>
        /// 是否允许多件累计抵扣  1是  2否
        /// </summary>        
        public int? IsMultipleDeduction
        {
            get;
            set;
        }
        /// <summary>
        /// 商品详情
        /// </summary>        
        public string GoodsDetails
        {
            get;
            set;
        }
        /// <summary>
        /// 删除状态
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// UpdateDate
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }
        /// <summary>
        /// 是否开启单独分销   1是  2否
        /// </summary>        
        public int? SeparateDistribution
        {
            get;
            set;
        }
        /// <summary>
        /// 单独分销类型  1普通设置  2详细设置
        /// </summary>        
        public int? SeparateDistributionType
        {
            get;
            set;
        }
        /// <summary>
        /// 分销佣金类型   2固定金额   1百分比
        /// </summary>        
        public int? SeparateDistributionMoneyType
        {
            get;
            set;
        }
        /// <summary>
        /// 是否享受会员功能   1是  2否
        /// </summary>        
        public int? EnjoyMember
        {
            get;
            set;
        }
        /// <summary>
        /// 是否单独设置会员价  1是  2否
        /// </summary>        
        public int? SeparateSetMember
        {
            get;
            set;
        }
        /// <summary>
        /// 是否加入快速购买  1是  2否
        /// </summary>
        public int? IsQuickBuy { get; set; }
        /// <summary>
        /// 是否畅销  1是  2否
        /// </summary>
        public int? IsSellWell { get; set; }

        /// <summary>
        /// 商品类型
        /// </summary>
        public OrderTypeEnum? GoodsType { get; set; }



        /// <summary>
        /// 上架版面
        /// </summary>
        public GoodsPageTypeEnum? GoodsPageType { get; set; }

        /// <summary>
        /// 供应商id
        /// </summary>
        public int SupplierId { get; set; }
        /// <summary>
        /// 商品是否可代理  1是  2否
        /// </summary>
        public int? IsProxy { get; set; }
        /// <summary>
        /// 代理成本上浮类型  1百分比  2固定金额
        /// </summary>
        public int? ProxyType { get; set; }
        /// <summary>
        /// 价格上涨
        /// </summary>
        public decimal? ProxyRises { get; set; }
        /// <summary>
        /// 代理价格
        /// </summary>
        public decimal? ProxyMoney { get; set; }
        /// <summary>
        /// 是否是采购商品  1是  2否
        /// </summary>
        public int? IsProcurement { get; set; }
        /// <summary>
        /// 采购状态  1正常  2代理下架
        /// </summary>
        public int? ProcurementStatus { get; set; }


        /// <summary>
        /// 返佣总金额
        /// </summary>
        public decimal Commission { get; set; }

        /// <summary>
        /// 赠送粉象等级
        /// </summary>
        public int? PresentFXGrade { get; set; }
        /// <summary>
        /// 赠送的月份  几个月
        /// </summary>
        public int? PresentFXMonth { get; set; }
        /// <summary>
        /// 广告词
        /// </summary>
        public string Advertising { get; set; }
        /// <summary>
        /// 副标题
        /// </summary>
        public string SubName { get; set; }

        /// <summary>
        /// 营销标识（文字+文字颜色+文字背景/  图标）
        /// </summary>
        public string MarketingLogo { get; set; }

        /// <summary>
        /// 是否是直播商品   1是   2否
        /// </summary>
        public int? IsLiveGoods { get; set; }

        /// <summary>
        /// 自动上架时间
        /// </summary>
        public DateTime? ShelvesDate { get; set; }

        /// <summary>
        /// 自动下架时间
        /// </summary>
        public DateTime? DownDate { get; set; }

        /// <summary>
        /// 发货地
        /// </summary>
        public string SendArea { get; set; }
        /// <summary>
        /// 商品分类  0正常商品  1司导商品   2教育商品,3-线下服务产品
        /// </summary>
        public int GoodsClassify { get; set; }
        /// <summary>
        /// 站点id
        /// </summary>
        public int? SiteId { get; set; }
        /// <summary>
        /// 导游id
        /// </summary>
        public int? GuideId { get; set; }
        /// <summary>
        /// 车辆id
        /// </summary>
        public int? CarId { get; set; }
        /// <summary>
        /// 车颜色id
        /// </summary>
        public int? CarColorId { get; set; }
        /// <summary>
        /// 车牌号
        /// </summary>
        public string CarNumber { get; set; }
        /// <summary>
        /// 车购买年份
        /// </summary>
        public string CarBuyYear { get; set; }
        /// <summary>
        /// 服务类型  枚举
        /// </summary>
        public GuideCarGoodsTypeEnum? CarType { get; set; }
        /// <summary>
        /// 使用日期 天
        /// </summary>
        public decimal? UseDay { get; set; }
        /// <summary>
        /// 线路名称
        /// </summary>
        public string LineName { get; set; }

        /// <summary>
        /// 关联城市或景点
        /// </summary>
        public string LineDescription { get; set; }

        /// <summary>
        /// 是否拼座  1是  2否
        /// </summary>
        public int? IsSpell { get; set; }

        /// <summary>
        /// 乘坐人数
        /// </summary>
        public int? RideNum { get; set; }
        /// <summary>
        /// 提前预定时间
        /// </summary>
        public int? AdvanceDay { get; set; }

        /// <summary>
        /// 视频填充方式(0默认，1-填充)
        /// </summary>
        public int VideoType { get; set; }

        /// <summary>
        /// 评论积分赠送
        /// </summary>        
        public int? IntegralComment
        {
            get;
            set;
        }
        /// <summary>
        /// 评论赠送类型  2固定值  1百分比
        /// </summary>        
        public int? IntegralCommentType
        {
            get;
            set;
        }

        /// <summary>
        /// 商品备注
        /// </summary>
        public string Remark { get; set; }

        /// <summary>
        /// 课程分数
        /// </summary>
        public decimal? CourseScore { get; set; }

        /// <summary>
        /// 课程标签
        /// </summary>
        public string CourseLable { get; set; }

        /// <summary>
        /// 定金
        /// </summary>
        public decimal DepositMoney { get; set; }

        /// <summary>
        /// 是否选择服务人员(0-不选,1-选择)
        /// </summary>
        public int IsChooseServicePerson { get; set; }

        /// <summary>
        /// 门店编号
        /// </summary>
        public string StoresIds { get; set; }

        /// <summary>
        /// 服务时长
        /// </summary>
        public decimal ServiceTime { get; set; }


        /// <summary>
        /// 是否为不可开发票商品，1-是
        /// </summary>
        public int IsNoTax { get; set; }

        /// <summary>
        /// 最低利润率
        /// </summary>
        public decimal MinProfitRate { get; set; }

        /// <summary>
        /// 商品所属国家
        /// </summary>
        public string GoodsCountry { get; set; }

        /// <summary>
        /// 商品地址
        /// </summary>
        public string FatCode { get; set; }

        /// <summary>
        /// 商品简介
        /// </summary>
        public string GoodsUrl { get; set; }

        /// <summary>
        /// 商品Logo
        /// </summary>
        public string goodsLogo { get; set; }

        /// <summary>
        /// 分销平台，0-否，1-是
        /// </summary>
        public int RetailStore { get; set; }

        /// <summary>
        /// 源数据商品id
        /// </summary>
        public int SourceGoodsId { get; set; }

        /// <summary>
        /// 源数据商户号
        /// </summary>        
        public int SourceTenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 源数据小程序id
        /// </summary>        
        public int SourceMallBaseId
        {
            get;
            set;
        }

        /// <summary>
        /// 默认值
        /// </summary>
        private int create_by = -1;

        /// <summary>
        /// 创建人1
        /// </summary>
        public int CreateBy { get => create_by; set => create_by= value; }
    }
}
