﻿using Mall.Common;
using Mall.Model.Extend.User;
using Mall.Repository.User;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Module.User
{
   /// <summary>
   /// 用户查看微信日志处理类
   /// </summary>
   public class MemberLookModule
    {
        /// <summary>
        /// 用户查看微信日志仓储层对象
        /// </summary>
        private readonly RB_Member_LookRepository member_LookRepository = new RB_Member_LookRepository();
        /// <summary>
        /// 
        /// </summary>
        private readonly RB_Member_UserRepository member_UserRepository = new RB_Member_UserRepository();

        /// <summary>
        /// 获取用户查看微信日志分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Member_Look_Extend> GetMemberLookPageModule(int pageIndex, int pageSize, out long rowsCount, RB_Member_Look_Extend query)
        {
            return member_LookRepository.GetMemberLookPageRepository(pageIndex, pageSize, out rowsCount, query);
        }

        /// <summary>
        /// 获取用户查看日志列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Member_Look_Extend> GetMemberLookListModule(RB_Member_Look_Extend query)
        {
            return member_LookRepository.GetMemberLookListRepository(query);
        }

        /// <summary>
        /// 新增用户查看日志
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddMemberLookModule(RB_Member_Look_Extend model)
        {
            #region 验证当月时长已存在
            string STime = DateTime.Now.ToString("yyyy-MM") + "-01";
            string ETime = Convert.ToDateTime(STime).AddMonths(1).AddDays(-1).ToString("yyyy-MM-dd");
            var list = member_LookRepository.GetMemberLookListRepository(new RB_Member_Look_Extend() { MallBaseId = model.MallBaseId, UserId = model.UserId, CreateBy = model.CreateBy, StartTime = STime, EndTime = ETime });
            if (list.Any()) {
                return false;
            }
            #endregion

            var newId = member_LookRepository.Insert(model);
            model.LookId = newId;
            return newId > 0;
        }

        /// <summary>
        /// 获取用户查看次数
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="userInfo"></param>
        /// <returns></returns>
        public object GetWeChatLookUser(int userId, AppletUserInfo userInfo)
        {
            string STime = DateTime.Now.ToString("yyyy-MM") + "-01";
            string ETime = Convert.ToDateTime(STime).AddMonths(1).AddDays(-1).ToString("yyyy-MM-dd");
            //首先查询是否已查看
            bool IsLook = false;
            var list = member_LookRepository.GetMemberLookListRepository(new RB_Member_Look_Extend() { MallBaseId = userInfo.MallBaseId, UserId = userId, CreateBy = userInfo.UserId, StartTime = STime, EndTime = ETime });
            if (list.Any())
            {
                IsLook = true;
            }
            //查询当月已查看次数
            int LookNum = member_LookRepository.GetMemberLookNum(userInfo.MallBaseId, userInfo.UserId, STime, ETime);
            //查询用户可查看次数
            var umodel = member_UserRepository.GetEntity(userInfo.UserId);
            int TotalNum = umodel.LookTimes;
            if (umodel.LookTimes <= 0) { 
                //查询配置表中

            }

            return new
            {
                IsLook,
                TotalNum,
                SurplusNum = TotalNum - LookNum > 0 ? TotalNum - LookNum : 0
            };
        }
    }
}
