﻿using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Entity.Product
{
    /// <summary>
    /// 拼团活动表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Groupbuy_Activity
    {
        /// <summary>
        /// 活动编号[主键]
        /// </summary>
        public int ActivityId { get; set; }

        /// <summary>
        /// 活动开始时间
        /// </summary>
        public DateTime StartTime { get; set; }

        /// <summary>
        /// 活动结束时间
        /// </summary>
        public DateTime EndTime { get; set; }

        /// <summary>
        /// 商品编号
        /// </summary>
        public int GoodId { get; set; }

        /// <summary>
        /// 上架状态(1-上架,2-下架中,3-删除)
        /// </summary>
        public int GoodsStatus { get; set; }

        /// <summary>
        /// 排序
        /// </summary>
        public int Sort { get; set; }

        /// <summary>
        /// 售价
        /// </summary>
        public decimal SellingPrice { get; set; }

        /// <summary>
        /// 是否开启虚拟成团(1-开启)
        /// </summary>
        public int Is_Auto_Add_Robot { get; set; }

        /// <summary>
        /// 已团商品数
        /// </summary>
        public int Virtual_Sales { get; set; }

        /// <summary>
        /// 是否允许单独购买(1-开启)
        /// </summary>
        public int Is_Alone_Buy { get; set; }

        /// <summary>
        /// 是否默认商品服务(1是,2否)
        /// </summary>
        public int IsDefaultService { get; set; }

        /// <summary>
        /// 商品服务  json格式
        /// </summary>
        public string GoodsService { get; set; }

        /// <summary>
        /// 运费设置Id
        /// </summary>
        public int FreightId { get; set; }

        /// <summary>
        /// 自定义表单Id
        /// </summary>
        public int FormsId { get; set; }

        /// <summary>
        /// 商品限购数量
        /// </summary>
        public int Confine_Count { get; set; }

        /// <summary>
        /// 订单限购数量
        /// </summary>
        public int Confine_Order_Count { get; set; }

        /// <summary>
        /// 单品满件包邮
        /// </summary>
        public int Pieces { get; set; }

        /// <summary>
        /// 单品满额包邮
        /// </summary>
        public int Forehead { get; set; }

        /// <summary>
        /// 区域购买(1-开启)
        /// </summary>
        public int Is_Area_Limit { get; set; }

        /// <summary>
        /// 允许购买区域
        /// </summary>
        public string Area_limit { get; set; }

        /// <summary>
        /// 添加到快速购买(1-开启)
        /// </summary>
        public int Is_quick_shop { get; set; }

        /// <summary>
        /// 积分值
        /// </summary>
        public int Give_integral { get; set; }

        /// <summary>
        /// 积分类型(1-固定值,2-百分比)
        /// </summary>
        public int Give_integral_type { get; set; }

        /// <summary>
        /// 积分抵扣(1-开启)
        /// </summary>
        public int Is_forehead_integral { get; set; }

        /// <summary>
        /// 最多抵扣(1-固定值,2-百分比)
        /// </summary>
        public int Forehead_integral_type { get; set; }

        /// <summary>
        /// 允许多件累计抵扣(1-允许)
        /// </summary>
        public int Accumulative { get; set; }

        /// <summary>
        /// 卡卷编号
        /// </summary>
        public string CardIds { get; set; }

        /// <summary>
        /// 自定义分享标题
        /// </summary>
        public string App_share_title { get; set; }

        /// <summary>
        /// 自定义分享图片
        /// </summary>
        public string App_share_pic { get; set; }

        /// <summary>
        /// 商户小程序
        /// </summary>
        public int MallBaseId { get; set; }

        /// <summary>
        /// 商户编号
        /// </summary>
        public int TenantId { get; set; }
    }
}
