﻿using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.User
{
    public class RB_Vip_BuyRepository : BaseRepository<RB_Vip_Buy>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Vip_Buy); } }
        /// <summary>
        /// Vip购买信息列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Vip_Buy_Extend> GetVipBuyPageList(int pageIndex, int pageSize, out long rowCount, RB_Vip_Buy_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT a.*,b.`Name` as UserName FROM rb_vip_buy as a LEFT JOIN rb_member_user as b on a.UserId=b.Id WHERE   a.{nameof(RB_Vip_Buy_Extend.Status)}=0");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Vip_Buy_Extend.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Vip_Buy_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.Id > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Vip_Buy_Extend.Id)}={query.Id}");
                }
                if (query.UserId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Vip_Buy_Extend.UserId)}={query.UserId}");
                }
                if (query.PayState > -1)
                {
                    builder.Append($" AND a.{nameof(RB_Vip_Buy_Extend.PayState)}={query.PayState}");
                }

            }
            builder.Append($" order by a.{nameof(RB_Vip_Buy_Extend.Id)} desc");
            return GetPage<RB_Vip_Buy_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }


        /// <summary>
        /// Vip购买信息列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Vip_Buy_Extend> GetVipBuyList(RB_Vip_Buy_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE {nameof(RB_Vip_Buy_Extend.Status)}=0 ");
            if (query != null)
            {
                if (query.Id > 0)
                {
                    builder.Append($" AND {nameof(RB_Vip_Buy_Extend.Id)}={query.Id}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Vip_Buy_Extend.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND {nameof(RB_Vip_Buy_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.UserId > 0)
                {
                    builder.Append($" AND {nameof(RB_Vip_Buy_Extend.UserId)}={query.UserId}");
                }
                if (query.ReOrderId > 0)
                {
                    builder.Append($" AND {nameof(RB_Vip_Buy_Extend.ReOrderId)}={query.ReOrderId}");
                }
            }
            return Get<RB_Vip_Buy_Extend>(builder.ToString()).ToList();
        }

        /// <summary>
        /// 获取vip购买返佣分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Vip_Buy_Extend> GetVipBuyCommissionPageList(int pageIndex, int pageSize, out long rowCount, RB_Vip_Buy_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($@" SELECT a.*,b.`Name` as UserName 
FROM rb_vip_buy as a 
INNER JOIN rb_member_user as b on a.UserId=b.Id 
Left JOIN rb_vipbuy_commission c on a.Id = c.OrderId
WHERE a.{nameof(RB_Vip_Buy_Extend.Status)}=0 ");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Vip_Buy_Extend.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Vip_Buy_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.Id > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Vip_Buy_Extend.Id)}={query.Id}");
                }
                if (query.UserId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Vip_Buy_Extend.UserId)}={query.UserId}");
                }
                if (query.DistributionUserId > 0)
                {
                    builder.Append($" AND c.{nameof(RB_VipBuy_Commission.UserId)}={query.DistributionUserId}");
                }
                if (!string.IsNullOrEmpty(query.OrderNo))
                {
                    builder.Append($" AND a.{nameof(RB_Vip_Buy_Extend.OrderNo)} like '%{query.OrderNo}%'");
                }
                if (query.ReOrderId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Vip_Buy_Extend.ReOrderId)}={query.ReOrderId}");
                }
                if (!string.IsNullOrEmpty(query.ReOrderNum))
                {
                    builder.Append($" AND a.{nameof(RB_Vip_Buy_Extend.ReOrderNum)} like '%{query.ReOrderNum}%'");
                }
            }
            builder.Append($@" group by a.Id order by a.Id desc");
            return GetPage<RB_Vip_Buy_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }
    }
}
